package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.wolf.dubbo.DubboResult;

@AdvancedFeignClient
public interface RemoteMediaActivitySlotStatisticsStatService {
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<Integer> selectSlotDataCount(ReqSlotStatDataByPage req);

    DubboResult<Integer> selectSlotDailyDataCount(ReqSlotStatDailyByPage req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectSlotData(ReqSlotStatDataByPage req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<MeidaActivitySlotStatisticsDto> selectSumSlotData(ReqSlotStatDataByPage req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectSlotDailyData(ReqSlotStatDailyByPage req);

    DubboResult<Integer> updateSlotDailyData(ReqUpdateSlotDailyData req);

    DubboResult<Integer> batchUpdateSlotDailyData(List<ManualSlotDailyStatDto> req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectSlotDailyDataBySlotAndDate(List<ManualSlotDailyStatDto> req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectAppData(ReqAppStatistics req);
    
    DubboResult<MeidaActivitySlotStatisticsDto> selectAppSumData(ReqAppStatistics req);

    DubboResult<Integer> selectAppDataCount(ReqAppStatistics req);

    DubboResult<Integer> selectAppDailyDataCount(ReqAppDailyStatistics req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectAppDailyData(ReqAppDailyStatistics req);

    DubboResult<Integer> selectAppSlotDailyCount(ReqAppSlotDailyStatistics req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectAppSlotDailyData(ReqAppSlotDailyStatistics req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectAppSlotData(ReqAppSlotStatistics req);
    
    DubboResult<MeidaActivitySlotStatisticsDto> selectAppSlotSumData(ReqAppSlotStatistics req);

    DubboResult<Integer> selectAppSlotDataCount(ReqAppSlotStatistics req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectChangeSlotTotalData(ReqAppStatistics req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<MeidaActivitySlotStatisticsDto> selectChangeSlotTotalSumData(ReqAppStatistics req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectChangeSlotDailyData(ReqAppDailyStatistics req);

    DubboResult<Integer> selectActivityMediaSoltAmount(ReqActivitySlotDataByPage param);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<Integer> selectActivitySoltAmount(ReqActivitySlotDataByPage param);

    DubboResult<Integer> selectActivitySoltDailyAmount(ReqActivitySlotDataByPage param);

    DubboResult<Integer> selectActivityStatCount(ReqActivityStatDataByPage req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectActivityStatData(ReqActivityStatDataByPage req);
    
    DubboResult<MeidaActivitySlotStatisticsDto> selectActivityStatSumData(ReqActivityStatDataByPage req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<Integer> selectActAppStatCount(ReqActAppStatDataByPage req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectActAppStatData(ReqActAppStatDataByPage req);
    
    DubboResult<MeidaActivitySlotStatisticsDto> selectActAppStatSumData(ReqActAppStatDataByPage req);

    DubboResult<Integer> selectActAppStatDailyCount(ReqActAppStatDailyByPage req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectActAppStatDailyData(ReqActAppStatDailyByPage req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectActivityMediaSoltDataByPage(ReqActivitySlotDataByPage param);
    
    DubboResult<MeidaActivitySlotStatisticsDto> selectActivityMediaSoltSumData(ReqActivitySlotDataByPage param);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectActivitySoltDataByPage(ReqActivitySlotDataByPage param);
    
    DubboResult<MeidaActivitySlotStatisticsDto> selectActivitySoltSumData(ReqActivitySlotDataByPage param);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectActivitySoltDailyByPage(ReqActivitySlotDataByPage param);

    DubboResult<MeidaActivitySlotStatisticsDto> selectSlotDailyDataById(Long id);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectSlotActByPage(ReqActivitySlotDataByPage req);

    DubboResult<MeidaActivitySlotStatisticsDto> selectSlotActTotal(ReqActivitySlotDataByPage req);

    DubboResult<Integer> selectSlotActAmount(ReqActivitySlotDataByPage req);
    
    /**
     * 
     * selectActivityDailyAmount:(查询活动每日数据数量). <br/>
     *
     * @author guyan
     * @param req
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer>  selectActivityDailyAmount(ReqActDailyStatDataByPage req);
    
    /**
     * 
     * selectActivityDailyData:(查询活动每日数据). <br/>
     *
     * @author guyan
     * @param req
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<MeidaActivitySlotStatisticsDto>>  selectActivityDailyData(ReqActDailyStatDataByPage req);
    
}
