/**
 * Project Name:media-api<br>
 * File Name:ReqUpdateSlotStrategy.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto.req<br>
 * Date:2016年10月19日下午5:18:28<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: ReqUpdateSlotStrategy <br/>
 * date: 2016年10月19日 下午5:18:28 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class ReqUpdateSlotStrategy implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID  = 6418438363278489238L;

    @ApiModelProperty(value = "业务端屏蔽策略ID", required = false)
    private Long              strategyId;
    
    @ApiModelProperty(value = "管理端屏蔽策略ID", required = false)
    private Long              managerStrategyId;

    /** 屏蔽行业列表，中间以逗号隔开. */
    @ApiModelProperty(value = "屏蔽行业列表，中间以逗号隔开", required = false)
    private List<String>      shieldIndustries;

    /** 屏蔽广告列表，中间以逗号隔开. */
    @ApiModelProperty(value = "屏蔽广告列表，中间以逗号隔开", required = false)
    private List<String>      advertTagNums;

    /** 屏蔽广告主URL列表， 中间以逗号隔开. */
    @ApiModelProperty(value = "屏蔽广告主URL列表， 中间以逗号隔开", required = false)
    private List<String>      shieldAdvertisers;

    /**屏蔽活动标签， 中间以逗号隔开.*/
    @ApiModelProperty(value = "屏蔽活动标签， 中间以逗号隔开", required = false)
    private List<String>      shieldActivitys;

    @ApiModelProperty(value = "屏蔽落地页标签")
    private List<String>	  promoteTagNums;

    /** The industry flag. */
    private boolean           industryFlag      = false;

    /** The advertiser flag. */
    private boolean           advertiserFlag    = false;

    /** The advertTagNums flag. */
    private boolean           advertTagNumsFlag = false;

	/**The activitys flag.*/
    private boolean           activitysFlag=false;
   
    /** 广告位id*/
    private Long             slotId;
   

    /**
     * shieldIndustries.
     *
     * @return the shieldIndustries
     * @since JDK 1.6
     */
    public List<String> getShieldIndustries() {
        return shieldIndustries;
    }

    /**
     * shieldIndustries.
     *
     * @param shieldIndustries the shieldIndustries to set
     * @since JDK 1.6
     */
    public void setShieldIndustries(List<String> shieldIndustries) {
        this.shieldIndustries = shieldIndustries;
    }

    /**
     * shieldAdvertisers.
     *
     * @return the shieldAdvertisers
     * @since JDK 1.6
     */
    public List<String> getShieldAdvertisers() {
        return shieldAdvertisers;
    }

    /**
     * shieldAdvertisers.
     *
     * @param shieldAdvertisers the shieldAdvertisers to set
     * @since JDK 1.6
     */
    public void setShieldAdvertisers(List<String> shieldAdvertisers) {
        this.shieldAdvertisers = shieldAdvertisers;
    }

    /**
     * strategyId.
     *
     * @return the strategyId
     * @since JDK 1.6
     */
    public Long getStrategyId() {
        return strategyId;
    }

    /**
     * strategyId.
     *
     * @param strategyId the strategyId to set
     * @since JDK 1.6
     */
    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    /**
     * advertTagNums.
     *
     * @return the advertTagNums
     * @since JDK 1.6
     */
    public List<String> getAdvertTagNums() {
        return advertTagNums;
    }

    /**
     * advertTagNums.
     *
     * @param advertTagNums the advertTagNums to set
     * @since JDK 1.6
     */
    public void setAdvertTagNums(List<String> advertTagNums) {
        this.advertTagNums = advertTagNums;
    }

    /**
     * industryFlag.
     *
     * @return the industryFlag
     * @since JDK 1.6
     */
    public boolean isIndustryFlag() {
        return industryFlag;
    }

    /**
     * industryFlag.
     *
     * @param industryFlag the industryFlag to set
     * @since JDK 1.6
     */
    public void setIndustryFlag(boolean industryFlag) {
        this.industryFlag = industryFlag;
    }

    /**
     * advertiserFlag.
     *
     * @return the advertiserFlag
     * @since JDK 1.6
     */
    public boolean isAdvertiserFlag() {
        return advertiserFlag;
    }

    /**
     * advertiserFlag.
     *
     * @param advertiserFlag the advertiserFlag to set
     * @since JDK 1.6
     */
    public void setAdvertiserFlag(boolean advertiserFlag) {
        this.advertiserFlag = advertiserFlag;
    }

    /**
     * advertTagNumsFlag.
     *
     * @return the advertTagNumsFlag
     * @since JDK 1.6
     */
    public boolean isAdvertTagNumsFlag() {
        return advertTagNumsFlag;
    }

    /**
     * advertTagNumsFlag.
     *
     * @param advertTagNumsFlag the advertTagNumsFlag to set
     * @since JDK 1.6
     */
    public void setAdvertTagNumsFlag(boolean advertTagNumsFlag) {
        this.advertTagNumsFlag = advertTagNumsFlag;
    }

    /**
     * shieldActivitys.
     *
     * @return the shieldActivitys
     * @since JDK 1.6
     */
    public List<String> getShieldActivitys() {
		return shieldActivitys;
	}

    /**
     * shieldActivitys.
     *
     * @param shieldActivitys the shieldActivitys to set
     * @since JDK 1.6
     */
	public void setShieldActivitys(List<String> shieldActivitys) {
		this.shieldActivitys = shieldActivitys;
	}

	/**
     * activitysFlag.
     *
     * @return the activitysFlag
     * @since JDK 1.6
     */
	public boolean isActivitysFlag() {
		return activitysFlag;
	}

	/**
     * activitysFlag.
     *
     * @param activitysFlag the activitysFlag to set
     * @since JDK 1.6
     */
	public void setActivitysFlag(boolean activitysFlag) {
		this.activitysFlag = activitysFlag;
	}
	
	/**
     * managerStrategyId.
     *
     * @return the managerStrategyId
     * @since JDK 1.6
     */
	public Long getManagerStrategyId() {
	    return managerStrategyId;
	 }

	/**
     * managerStrategyId.
     *
     * @param managerStrategyId the managerStrategyId to set
     * @since JDK 1.6
     */    
	public void setManagerStrategyId(Long managerStrategyId) {
	    this.managerStrategyId = managerStrategyId;
	}
	
	/**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
	public Long getSlotId() {
	    return slotId;
	}

	/**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */      
	public void setSlotId(Long slotId) {
	     this.slotId = slotId;
	}

	public List<String> getPromoteTagNums() {
		return promoteTagNums;
	}

	public void setPromoteTagNums(List<String> promoteTagNums) {
		this.promoteTagNums = promoteTagNums;
	}

	@Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
