package cn.com.duiba.tuia.ssp.center.api.dto;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @author fangzhipeng
 * @date 2018/8/1
 */
public class AdvTagCreateDto {

    private Date gmtCreate;

    private String tagCode;

    /**
     * 判断当前tagCode 下面是否存在大于等于gmtCreate 时间的广告
     * true-存在对应广告 false-不存在
     */
    private boolean haveAdv = false;

    public AdvTagCreateDto() {}

    /**
     * 将gmtCreate 转换为gmtCreate
     * @param gmtCreate 创建时间
     * @param tagCode tagCode
     */
    public AdvTagCreateDto(String gmtCreate, String tagCode) {
        Instant instant = LocalDateTime.parse(gmtCreate, DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss"))
                .atZone(ZoneId.systemDefault()).toInstant();
        this.gmtCreate = Date.from(instant);
        this.tagCode = tagCode;
    }

    public AdvTagCreateDto(Date gmtCreate, String tagCode) {
        this.gmtCreate = gmtCreate;
        this.tagCode = tagCode;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getTagCode() {
        return tagCode;
    }

    public void setTagCode(String tagCode) {
        this.tagCode = tagCode;
    }

    public boolean isHaveAdv() {
        return haveAdv;
    }

    public void setHaveAdv(boolean haveAdv) {
        this.haveAdv = haveAdv;
    }


}
