/**
 * 
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 此类描述的是：分页查询共用返回结果.
 *
 * @param <T> the generic type
 * @author: leiliang
 * @version: 2016年2月25日 下午3:06:54
 */
public class PageResultDto<T extends Serializable> implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 7622601582262632184L;

    /** 总数. */
    private long              totalCount;

    /** 总页数. */
    private int               totalPage;

    /** The data. */
    private List<T>           list;
   
    /** the object*/
    private T                 sum;

    
    

    /**
     * 
     * Creates a new instance of PageResultDto.
     *
     */
    public PageResultDto() {
        super();
    }

    /**
     * 
     * Creates a new instance of PageResultDto.
     *
     * @param totalCount 总记录数
     * @param list 数据列表
     * @param pageSize 每页记录数
     */
    public PageResultDto(long totalCount, List<T> list, int pageSize) {
        super();
        this.totalCount = totalCount;
        this.list = list;
        this.totalPage = setToalPage(pageSize);
    }
    
    /**
     * 
     * Creates a new instance of PageResultDto.
     *
     * @param totalCount 总记录数
     * @param list 数据列表
     * @param pageSize 每页记录数
     * @param sum 对象
     */
    public PageResultDto(long totalCount, List<T> list, T sum, int pageSize) {
        super();
        this.totalCount = totalCount;
        this.list = list;
        this.sum=sum;
        this.totalPage = setToalPage(pageSize);
    }

    /**
     * 设置总页数.
     *
     * @param pageSize 每页记录数
     * @return the int
     */
    private int setToalPage(int pageSize) {
        if (totalCount < 0) {
            return 0;
        }

        return (int) ((totalCount % pageSize == 0) ? totalCount / pageSize : totalCount / pageSize + 1);
    }

    /**
     * Gets the total page.
     *
     * @return the total page
     */
    public int getTotalPage() {
        return totalPage;
    }

    /**
     * @return the totalCount
     */
    public long getTotalCount() {
        return totalCount;
    }

    /**
     * @param totalCount the totalCount to set
     */
    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    /**
     * @return the list
     */
    public List<T> getList() {
        return list;
    }

    /**
     * @param list the list to set
     */
    public void setList(List<T> list) {
        this.list = list;
    }
    
    
    public T getSum() {
        return sum;
    }

    
    public void setSum(T sum) {
        this.sum = sum;
    }
    
    
    
   
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
