package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMediaRewardStrategyService {

    DubboResult<RSMonthPageDto> pageListOfRewardStrategy();

    DubboResult<PageResultDto<MediaRewardScoreDayDto>> listMRSD(ReqMediaRewardScoreMonth rewardScoreMonth, int showAllData);

    DubboResult<PageResultDto<MediaRewardScoreDayDto>> listMRSDAdd(ReqMediaRewardScoreMonth rewardScoreMonth, int showAllData);

    DubboResult<MediaRewardSettleResult> rewardSettlementSuc(MediaRewardScoreMonthDto scoreMonthDto);

    DubboResult<Integer> rewardAuditSucByRisk(MediaRewardScoreMonthDto scoreMonthDto);

    DubboResult<Integer> rewardAuditFailedByRisk(MediaRewardScoreMonthDto scoreMonthDto);

    DubboResult<Integer> rewardAuditSucByMedia(MediaRewardScoreMonthDto scoreMonthDto);

    DubboResult<Integer> rewardAuditFailedByMedia(MediaRewardScoreMonthDto scoreMonthDto);

    DubboResult<Integer> rewardAuditSucByFlow(MediaRewardScoreMonthDto scoreMonthDto);

    DubboResult<Integer> rewardAuditFailedByFlow(MediaRewardScoreMonthDto scoreMonthDto);

    DubboResult<MediaRewardBillDto> computeRewardByScore(Long mrsMonthId, Double score);

    DubboResult<MediaRewardDataDto> getMediaRewardInfo(Long mediaId);

    DubboResult<List<MediaRewardBillDto>> listNotCash(Long mediaId, Integer companyType);

    DubboResult<List<MediaRewardBillDto>> listByCashOrderId(Long cashOrderId);

    DubboResult<List<MediaRewardBillDto>> listByCashs(List<Long> cashOrderIds);

    MediaRewardStrategyDto listMRSByMediaAndCycle(Long mediaId, String curCycle);

    Integer addMediaRewardStrategy(MediaRewardStrategyDto mediaStrategyDto);

    AccountDto findMedia(Long mediaId);

    PageResultDto<MediaRewardStrategyDto> listMRS(ReqMediaRewardStrategy reqMediaRewardStrategy);

    MediaRewardStrategyDto findMRSById(Long mrsId);

    MediaRewardStrategyDto findMRSByBillId(Long mrbId);

    Integer updateMediaRewardStrategy(MediaRewardStrategyDto strategyDto);

    Integer updateRewardStrategy(RewardStrategyDto strategyDto);

    Integer delMrs(Long mrsId);

    PageResultDto<MediaRewardBillDto> pageList(ReqMediaRewardScoreMonth rewardScoreMonth);

    DubboResult<PageResultDto<MediaRewardBillDto> > listAuditedByMediaId(ReqMediaRewardScoreMonth reqMediaRewardScoreMonth);
    
    DubboResult<List<MediaRewardBillDto>> listMonthDataByIds(List<Long> ids, Integer companyType);

    void produceMediaRewardBill();

    DubboResult<PageResultDto<MediaRewardBillDto>> listAuditedByMediaIdToOneRecode(ReqMediaRewardScoreMonth reqMediaRewardScoreMonth);
}
