package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

@ApiModel public class DomainShieldInfoReq implements Serializable {
    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -64750653584382734L;

    @ApiModelProperty(value = "策略ID") private Long id;

    @ApiModelProperty(value = "屏蔽名称") private String shieldName;

    @ApiModelProperty(value = "当前页", required = true) private Integer currentPage;

    @ApiModelProperty(value = "每页记录数，为-1时代表查询所有", required = true) private Integer pageSize;

    @ApiModelProperty(value = "起始记录数", required = true) private Integer rowStart = 0;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getShieldName() {
        return shieldName;
    }

    public void setShieldName(String shieldName) {
        this.shieldName = shieldName;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getRowStart() {
        return rowStart;
    }

    public void setRowStart(Integer rowStart) {
        this.rowStart = rowStart;
    }

    @Override public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}

