package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

@ApiModel
public class MediaRewardDataDto extends RewardScoreBase implements Serializable {

    /**
     * 序列号
     */
    private static final long serialVersionUID = -9174622947686058497L;

    @ApiModelProperty(value = "今日预计得分")
    private Double scoreToday;

    public Double getScoreToday() {
        return scoreToday;
    }

    public void setScoreToday(Double scoreToday) {
        this.scoreToday = scoreToday;
    }

    @ApiModelProperty(value = "昨日预计得分")
    public Double getScoreYesToday() {
        return scoreYesToday;
    }

    public void setScoreYesToday(Double scoreYesToday) {
        this.scoreYesToday = scoreYesToday;
    }

    @ApiModelProperty(value = "上月预计得分")
    public Double getScoreYesMonth() {
        return scoreYesMonth;
    }

    public void setScoreYesMonth(Double scoreYesMonth) {
        this.scoreYesMonth = scoreYesMonth;
    }

    @ApiModelProperty(value = "奖励规则列表")
    public List<RewardStrategyDto.RewardRule> getRrList() {
        return rrList;
    }

    public void setRrList(List<RewardStrategyDto.RewardRule> rrList) {
        this.rrList = rrList;
    }

    private Double scoreYesToday;

    private Double scoreYesMonth;

    private List<RewardStrategyDto.RewardRule> rrList;

}
