package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 关联媒体与管理员dto
 * 
 * @author songjiaxing
 *
 */
@ApiModel(description = "关联媒体与管理员DTO")
public class ReqMediaManagerCreateDto implements Serializable {

	private static final long serialVersionUID = 6068506401223694710L;

	// 媒体ID
	@ApiModelProperty(value = "媒体id", dataType = "Long")
	@NotNull
	private Long mediaId;

	// 管理员ID
	@ApiModelProperty(value = "管理员id", dataType = "List<Long>")
	@NotNull
	private List<Long> managerId;

	public Long getMediaId() {
		return mediaId;
	}

	public void setMediaId(Long mediaId) {
		this.mediaId = mediaId;
	}

	public List<Long> getManagerId() {
		return managerId;
	}

	public void setManagerId(List<Long> managerId) {
		this.managerId = managerId;
	}

}
