package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountRemitDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaCashOrderDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqAccountRemitByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqCashDetail;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 媒体提现单service
 * 
 *
 */
@AdvancedFeignClient
public interface RemoteMediaCashOrderService {

    /**
     *  根据id查询一条提现单记录
     * @param id
     * @return
     */
    public DubboResult<MediaCashOrderDto>    getOrderById(Long id);

    /**
     * 
     * getOrdersList:(查询提现明细列表). <br/>
     * 
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<MediaCashOrderDto>>   getCashOrdersList(ReqCashDetail param);
    
    /**
     * 
     * getCashOrdersCount:(查询提现明细). <br/>
     *
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer>  getCashOrdersCount(ReqCashDetail param);

    /**
     * 修改提现状态，需修改cash_order表和account_report_month表状态
     * @param cashOrderId
     * @param status
     * @return
     */
    public DubboResult<Boolean>  updateCashStatus(Long cashOrderId,Integer status,String checkMsg);
    
    /**
     * 查询媒体提现订单通过月账单中的提现单IDs
     *
     * @param monthBillIds
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<MediaCashOrderDto>> selectMediaCashOrderListByIds(List<Long> cashOrderIds);
    
    /**
     * 
     * 分页查询提现确认打款清单
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<AccountRemitDto>> selectAccountRemitList(ReqAccountRemitByPage param);
    
    /**
     * 查询提现确认打款清单数量
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> selectAccountRemitCount(ReqAccountRemitByPage param);
    /**
     * 
     * selectOrderIdsByStatus:(通过审核状态和提现单ids查询提现单ids). <br/>
     *
     * @author guyan
     * @param cashOrderIds
     * @param checkStatus
     * @return
     */
    public DubboResult<List<Long>> selectOrderIdsByStatus(List<Long> cashOrderIds,Integer checkStatus);
    
    /**
     * updateCashRequirementStatus:更新请款状态. <br/>
     *
     * @author Administrator
     * @param id
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> updateCashRequirementStatus(Long id);
    
}
