package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaManagerDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMediaManagerCreateDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 媒体--管理员关联关系接口
 * 
 * @author songjiaxing
 *
 */
@AdvancedFeignClient
public interface RemoteMediaManagerBackendService {

	/**
	 * 关联媒体和管理员
	 * 
	 * @param managerDto
	 * @return
	 */
	public DubboResult<Integer> createMediaManager(ReqMediaManagerCreateDto createDto);

	/**
	 * 删除媒体和管理员关联关系
	 * 
	 * @param managerDto
	 * @return
	 */
	public DubboResult<Integer> deleteByMediaId(Long mediaId);

	/**
	 * 根据管理员id查询可操作的媒体
	 * 
	 * @param managerId
	 * @return
	 */
	public DubboResult<List<MediaManagerDto>> listByManagerId(Long managerId);

	/**
	 * 根据媒体id查询所属管理员
	 * 
	 * @param mediaId
	 * @return
	 */
	public DubboResult<List<MediaManagerDto>> listByMediaId(Long mediaId);

	public  DubboResult<List<MediaManagerDto>> listByMediaList(List<Long> medias);

}
