package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.TagLevel;
import cn.com.duiba.tuia.ssp.center.api.dto.VisibleTagsDto;
import cn.com.duiba.tuia.ssp.center.api.dto.advertselect.ShieldTagsDto;
import cn.com.duiba.tuia.ssp.center.api.dto.advertselect.TagLevelInfo;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMediaVisibleTagsService {

    /**
     * 查询可见标签
     *
     * @param mediaId
     * @return
     */
    VisibleTagsDto selectVisibleTags(Long mediaId);

    /**
     * 保存可见标签
     *
     * @param dto
     * @return
     */
    Boolean saveVisibleTags(VisibleTagsDto dto);

    /**
     * 修改可见标签
     *
     * @param dto
     * @return
     */
    Boolean updateVisibleTags(VisibleTagsDto dto);

    /**
     * @param mediaIds
     * @return
     */
    List<VisibleTagsDto> selectListByIds(List<Long> mediaIds);


    ShieldTagsDto computeShieldTags(VisibleTagsDto dto);

    /**
     * 通过媒体用户ID查询已经开启互选广告的APPID
     *
     * @return
     */
    List<Long> selectAppIdsById();

    /**
     * 根据广告位id查询标签的可见配置
     * @param slotId
     * @return
     */
    ShieldTagsDto findShieldTagsDtoBySlotId(Long slotId);

    /**
     * 根据广告位获取所有不可见的行业标签下拉列表
     * @param slotId
     * @return
     */
    List<TagLevelInfo> findAllInvisibleIndustriesTags(Long slotId);

    /**
     * 根据广告位获取所有不可见的属性标签下拉列表
     * @param slotId
     * @return
     */
    List<TagLevelInfo> findAllInvisibleAdvertTags(Long slotId);

    /**
     * 根据广告位获取所有不可见的落地页标签下拉列表
     * @param slotId
     * @return
     */
    List<TagLevelInfo> findAllInvisiblePromoteTags(Long slotId);


}
