/**
 * Project Name:media-manager-biz File Name:ReqActivityStatisticsByPage.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.req Date:2016年12月21日上午11:44:59 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * ClassName:ReqActAppStatHour <br/>
 * Function: 活动下媒体时段数据统计. <br/>
 * Date: 2016年12月21日 上午11:44:59 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqActAppStatHour extends ReqStatHourlySort implements Serializable {

    /** 序列号. */
    private static final long serialVersionUID = -1158637634156561218L;

    /** 查询日期. */
    @ApiModelProperty(value = "查询日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "查询日期不能为空")
    private String            curDate;

    /** 活动ID. */
    @ApiModelProperty(value = "活动ID", required = true)
    @NotNull(message = "活动ID不能为空")
    private Long              activityId;

    /** 媒体ID. */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long              appId;

    /** 媒体名称. */
    @ApiModelProperty(value = "媒体名称", required = false)
    private String            appName;

    /** The activity name. */
    @ApiModelProperty(value = "活动名称(用作导出)", required = false)
    private String            activityName;
    
    @ApiModelProperty(value = "活动数据来源", required = false)
    private Integer          source;

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.6
     */
    public String getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.6
     */
    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    /**
     * activityId.
     *
     * @return the activityId
     * @since JDK 1.6
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * activityId.
     *
     * @param activityId the activityId to set
     * @since JDK 1.6
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the app name.
     *
     * @return the app name
     */
    public String getAppName() {
        return appName;
    }

    /**
     * Sets the app name.
     *
     * @param appName the app name
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * Gets the activity name.
     *
     * @return the activity name
     */
    public String getActivityName() {
        return activityName;
    }

    /**
     * Sets the activity name.
     *
     * @param activityName the activity name
     */
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }
    
    /**
     * Gets the source.
     *
     * @return the source
     */
    public Integer getSource() {
        return source;
    }

    /**
     * Sets the source.
     *
     * @param source the source
     */
    public void setSource(Integer source) {
        this.source = source;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
