package cn.com.duiba.tuia.ssp.center.api.remote.slotproportioncheck;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.slotproportioncheck.SlotProportionCheckDto;
import cn.com.duiba.tuia.ssp.center.api.dto.slotproportioncheck.SlotProportionCheckReq;

import java.util.List;

/**
 * 广告位分成比例审核
 */
@AdvancedFeignClient
public interface RemoteSlotProportionCheckService {

    /**
     * 通过appId查询广告位分成比例审核列表
     *
     * @param appId
     * @return
     */
    List<SlotProportionCheckDto> listSlotProportionCheckByAppId(Long appId);

    /**
     * 广告位分成审核分页查询
     *
     * @param param
     * @return
     */
    PageResultDto<SlotProportionCheckDto> listSlotProportionCheckByPage(SlotProportionCheckReq param);

    /**
     * 修改广告位分成比例
     *
     * @param dto
     * @return
     */
    Boolean updateSlotProportion(SlotProportionCheckDto dto);

    /**
     * 查询广告位分成比例信息
     * @param id
     * @return
     */
    SlotProportionCheckDto getSlotProportionCheckById(Long id);

}
