package cn.com.duiba.tuia.ssp.center.api.constant;

/**
 * @author xuyenan
 * @createTime 2016/12/22
 */
public final class ActivityConstant {

    /**
     * 未删除
     */
    public static final int    IS_NOT_DELETE                  = 0;

    /**
     * 已删除
     */
    public static final int    IS_DELETE                      = 1;

    /**
     * 未发布为活动计划
     */
    public static final int    IS_NOT_PUBLISH                 = 0;

    /**
     * 已发布为活动计划
     */
    public static final int    IS_PUBLISH                     = 1;

    /**
     * 未启用
     */
    public static final int    IS_NOT_ENABLE                  = 0;

    /**
     * 已启用
     */
    public static final int    IS_ENABLE                      = 1;

    /**
     * 未定向媒体
     */
    public static final int    IS_NOT_DIRECT_MEDIA            = 0;

    /**
     * 已定向媒体
     */
    public static final int    IS_DIRECT_MEDIA                = 1;

    /**
     * 未定向广告
     */
    public static final int    IS_NOT_DIRECT_ADVERT           = 0;

    /**
     * 已定向广告
     */
    public static final int    IS_DIRECT_ADVERT               = 1;

    /**
     * 仅投放定向列表
     */
    public static final int    DIRECT_ADVERT_MODE_ONLY        = 1;

    /**
     * 优先投放定向列表
     */
    public static final int    DIRECT_ADVERT_MODE_PRIOR       = 2;

    /**
     * 非试投活动
     */
    public static final int    IS_NOT_NEW_ACT                 = 0;

    /**
     * 试投活动
     */
    public static final int    IS_NEW_ACT                     = 1;

    /**
     * 活动来源 0-兑吧
     */
    public static final int    REQ_ACT_SOURCE_DUIBA           = 0;

    /**
     * 活动来源 1-推啊
     */
    public static final int    REQ_ACT_SOURCE_TUIA            = 1;

    /**
     * 活动来源 2-流量引导页
     */
    public static final int    REQ_ACT_SOURCE_FLOW_GUIDE_PAGE = 2;

    /**
     * 活动来源 3-插件活动
     */
    public static final int    REQ_ACT_SOURCE_PLUGIN          = 3;


    /**
     * 来源  20-游戏
     */
    public static final int REQ_GAME_SOURCE = 20;
    /**
     * 来源  21-游戏大厅
     */
    public static final int REQ_GAME_HALL = 21;


    /**
     * 活动流量引导页
     */
    public static final String ACT_FLOW_GUIDE_PAGE            = "flow_guide_page";

    /**
     * 活动主会场
     */
    public static final String ACT_MAIN_MEET                  = "main_meet";

    /**
     * 非周期活动
     */
    public static final int    CYCLE_NONE                     = 0;

    /**
     * 按星期周期活动
     */
    public static final int    CYCLE_WEEK                     = 1;

    /**
     * 按月周期活动
     */
    public static final int    CYCLE_MONTH                    = 2;

    /**
     * 所有周期活动
     */
    public static final int    CYCLE_ALL                      = -1;


    private ActivityConstant() {
    }

}
