package cn.com.duiba.tuia.ssp.center.api.constant.risk;

/**
 * 〈一句话功能简述〉<br>
 * Description: 审核业务类型
 *
 * @author hillchen
 * @create 2018/9/20 下午2:50
 */
public enum AuditBuzType {
    /**
     * 活动审核
     */
    BUZ_ACTIVITY(1,"活动审核"),
    /**
     * 流量引导页审核
     */
    BUZ_GUIDEPAGE(2,"流量引导页审核"),
    /**
     * 插件工具审核
     */
    BUZ_PLUG(3,"插件工具审核"),
    /**
     * 媒体素材审核
     */
    BUZ_MATERIAL(4,"媒体素材审核");
    private int type;

    private String desc;

    AuditBuzType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public  boolean checkIsSameType(Integer type){
        return type != null && this.type == type;
    }
}
