package cn.com.duiba.tuia.ssp.center.api.dto.advertselect;

import cn.com.duiba.tuia.ssp.center.api.constant.SlotShieldConstant;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * 说明:
 *
 * @author hillchen
 * @create 2018-08-01 17:25
 **/
public class SlotShieldStrategyDto implements Serializable {
    private static final long serialVersionUID = -1644504482546730031L;
    private Long id;

    /**媒体用户id**/
    private long mediaId;

    /**媒体应用id**/
    private long appId;

    /**广告位id**/
    private String slotIds;

    /**联系电话**/
    private String linkmanPhone;

    /**预期收入**/
    private Integer expectedIncome;

    /**策略消耗比率**/
    private Integer rate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public long getMediaId() {
        return mediaId;
    }

    public void setMediaId(long mediaId) {
        this.mediaId = mediaId;
    }

    public long getAppId() {
        return appId;
    }

    public void setAppId(long appId) {
        this.appId = appId;
    }

    public String getLinkmanPhone() {
        return linkmanPhone;
    }

    public void setLinkmanPhone(String linkmanPhone) {
        this.linkmanPhone = linkmanPhone;
    }

    public Integer getExpectedIncome() {
        return expectedIncome;
    }

    public void setExpectedIncome(Integer expectedIncome) {
        this.expectedIncome = expectedIncome;
    }

    public Integer getRate() {
        return rate;
    }

    public void setRate(Integer rate) {
        this.rate = rate;
    }

    public String getSlotIds() {
        return slotIds;
    }

    public void setSlotIds(String slotIds) {
        this.slotIds = slotIds;
    }

    public Set<Long> computeShieldSlotIds(){
        if(StringUtils.isNotBlank(slotIds)){
            String[] slotIdStrs = StringUtils.split(getSlotIds(), SlotShieldConstant.SLOT_SHIELD_SPLITTER);
            Set<Long> slotIds = new HashSet<>(slotIdStrs.length);
            for(String slotIdStr : slotIdStrs){
                slotIds.add(Long.parseLong(slotIdStr));
            }
            return slotIds;
        }
        return Collections.emptySet();
    }
}
