package cn.com.duiba.tuia.ssp.center.api.dto.monthreport;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 获取月报相关数据接口的请求参数
 *
 * @author fangzhipeng
 * @date 2018/9/15
 */
@ApiModel
public class ReqMonthReportDataDto implements GenEndDate {

    /**
     * 媒体账号id
     */
    @NotNull(message = "媒体id不能为空")
    @ApiModelProperty(value = "媒体Id", required = true)
    private Long mediaId;

    /**
     * 开始日期
     */
    @NotNull(message = "开始日期不能为空")
    @ApiModelProperty(value = "开始时间", required = true)
    private String startDate;

    /**
     * 结束日期
     */
    @NotNull(message = "结束日期不能为空")
    @ApiModelProperty(value = "结束日期", required = true)
    private String endDate;


    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    @Override
    public String getEndDate() {
        return endDate + " 23:59:59";
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
}
