/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.tool;

import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;

public class DataMathUtil {
    public static final DataMathUtil getInstance() {
        return DataMathUtilHolder.INSTANCE;
    }

    public Long calculateDivide(Long v1, Long v2, Integer s) {
        BigDecimal bigDecimal;
        if (Objects.isNull(s)) {
            s = SCALE.SCALE_NUM2.getNum();
        }
        return Objects.isNull(bigDecimal = DataMathUtil.divide(v1, v2, s, null)) ? 0L : bigDecimal.longValue();
    }

    public Long calculateDivide(Long v1, Long v2, Integer s, Integer v3) {
        BigDecimal bigDecimal;
        Objects.requireNonNull(v3, "\u4e58\u6570\u4e0d\u80fd\u4e3anull");
        if (Objects.isNull(s)) {
            s = SCALE.SCALE_NUM2.getNum();
        }
        return Objects.isNull(bigDecimal = DataMathUtil.divide(v1, v2, s, v3)) ? 0L : bigDecimal.longValue();
    }

    private static BigDecimal divide(Long v1, Long v2, Integer scale, Integer v3) {
        if (!DataMathUtil.checkParam(v1, v2, scale)) {
            return null;
        }
        BigDecimal divisor = ObjectUtils.notEqual((Object)v3, null) ? new BigDecimal(v1 * (long)v3.intValue()) : new BigDecimal(v1);
        BigDecimal Dividend = new BigDecimal(v2);
        return divisor.divide(Dividend, (int)scale, 4);
    }

    private static boolean checkParam(Long v1, Long v2, Integer scale) {
        if (Objects.isNull(v1) || Objects.isNull(v2) || Objects.isNull(scale)) {
            return false;
        }
        if (v2 == 0L) {
            return false;
        }
        return scale >= 0;
    }

    public static enum SCALE {
        SCALE_NUM0(0),
        SCALE_NUM1(1),
        SCALE_NUM2(2),
        SCALE_NUM3(3);

        private Integer num;

        private SCALE(Integer num) {
            this.num = num;
        }

        public Integer getNum() {
            return this.num;
        }
    }

    private static class DataMathUtilHolder {
        private static final DataMathUtil INSTANCE = new DataMathUtil();

        private DataMathUtilHolder() {
        }
    }
}

