package cn.com.duiba.tuia.ssp.center.api.dto.monthreport;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseDto;

import java.util.Date;

/**
 * 媒体月报dto
 * @author fangzhipeng
 * @date 2018/9/13
 */
public class MonthReportDto extends BaseDto {

    private static final long serialVersionUID = -1523894415122845269L;

    /**
     * 发送状态-未发送
     */
    public static final int SEND_STATUS_NOT = 0;

    /**
     * 发送状态-已发送
     */
    public static final int SEND_STATUS_SEND = 1;

    /**
     * 媒体账户id
     */
    private Long mediaId;

    /**
     * 月报日期 yyyy-MM 格式
     */
    private String reportDate;

    /**
     * 名称
     */
    private String title;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 创建人
     */
    private String creator;

    /**
     * 发送人
     */
    private String sender;

    /**
     * 发送时间
     */
    private Date sendTime;

    /**
     * 发送状态 0-未发送 1-已发送
     */
    private Integer sendStatus;

    /**
     * 是否删除 0-未删除 1-已删除
     */
    private Integer isDelete;

    /**
     * 前端保存的画布配置串
     */
    private String config;

    /**
     * 前端保存的截图图片地址
     */
    private String picUrl;

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getSender() {
        return sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public Integer getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public String getConfig() {
        return config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getPicUrl() {
        return picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public String getReportDate() {
        return reportDate;
    }

    public void setReportDate(String reportDate) {
        this.reportDate = reportDate;
    }
}
