/**
 * Project Name:media-api File Name:RspSettledMonthReportDto.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年11月30日下午3:52:36 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

import cn.com.duiba.tuia.ssp.center.api.constant.PathType;
import cn.com.duiba.tuia.ssp.center.api.tool.StringTool;
import com.google.common.collect.Lists;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:RspSettledMonthReportDto <br/>
 * Function: 已结算月报表. <br/>
 * Date: 2016年11月30日 下午3:52:36 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class SettledMonthReportRsp extends BaseAccountMonthReportRsp implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 3670897234679755232L;

    /** 月发劵量 */
    private Integer           monthAdvertCount;

    /** 月曝光数 */
    private Integer           monthShowCount;

    /** 月点击量 */
    private Integer           monthClickCount;

    /** 日点击uv总数 */
    private Integer           allDayClickUvCount;

    /** 月有效点击量 */
    private Integer           monthValidClickCount;

    /** 最终分成 */
    private Long              finalShare;

    /** 结算状态：0-待结算，1-默认结算，2-拒绝结算 */
    private Integer           checkStatus;

    /** 审核状态：0-拒绝，1-通过 */
    private Integer           auditStatus;

    /** 账户类型：0-普通用户 1-线下打款用户*/
    private Integer           isOffline;

    /** 线下打款金额 */
    private Long              offlineMoney;

    /** 广告位曝光  */
    private Long        actExposeCount;

    /** 广告位点击  */
    private Long        actClickCount;

    /** 广告位访问UV  */
    private Long        sdkUv;

    /** 活动广告券请求  */
    private Long        advertRequestCount;

    /** 发券成功率 */
    private Double        launchSuccessRate;

    /** 媒体CPM */
    private Double              mediaCPM;

    /** 媒体CPC */
    private Double              mediaCPC;

    /** 媒体UV单价 */
    private Double mediaUVPrice;

    /** 分成比例 */
    private Double divisionProportion;

    /** 实际分成比例 */
    private Double actualProportion;

    /** 结算拒绝原因 */
    private String rejectReason;
    
    /**用户类别*/
    private Integer accountType;
    
    /**调整金额*/
    private Long adjustmentAmount;
    
    /**税率*/
    private Integer taxRate;
   
    /**月账单生成日期*/
    private String gmtCreate;
    
    /**月账单结算日期*/
    private String currentDate;
    
    /**杭州实际分成*/
    private Long hzFinalShare;
    
    /**霍尔果斯实际分成*/
    private Long hegsFinalShare;

    /**杭州广告消耗*/
    private Long hzAdConsume;
    
    /**霍尔果斯广告消耗*/
    private Long hegsAdConsume;

    /**杭州应得收入*/
    private Long hzConsumeTotal;

    /**霍尔果斯应得收入*/
    private Long hegsConsumeTotal;

    /**杭州预计收入*/
    private Long hzExConsumeTotal;

    /**霍尔果斯预计收入*/
    private Long hegsExConsumeTotal;
   

    /**
     * settlementStatus.
     *
     * @return the settlementStatus
     * @since JDK 1.6
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.6
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * auditStatus.
     *
     * @return the auditStatus
     * @since JDK 1.6
     */
    public Integer getAuditStatus() {
        return auditStatus;
    }

    /**
     * auditStatus.
     *
     * @param auditStatus the auditStatus to set
     * @since JDK 1.6
     */
    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Integer getMonthAdvertCount() {
        return monthAdvertCount;
    }

    public void setMonthAdvertCount(Integer monthAdvertCount) {
        this.monthAdvertCount = monthAdvertCount;
    }

    public Integer getMonthShowCount() {
        return monthShowCount;
    }

    public void setMonthShowCount(Integer monthShowCount) {
        this.monthShowCount = monthShowCount;
    }

    public Integer getMonthClickCount() {
        return monthClickCount;
    }

    public void setMonthClickCount(Integer monthClickCount) {
        this.monthClickCount = monthClickCount;
    }

    public Integer getAllDayClickUvCount() {
        return allDayClickUvCount;
    }

    public void setAllDayClickUvCount(Integer allDayClickUvCount) {
        this.allDayClickUvCount = allDayClickUvCount;
    }

    public Integer getMonthValidClickCount() {
        return monthValidClickCount;
    }

    public void setMonthValidClickCount(Integer monthValidClickCount) {
        this.monthValidClickCount = monthValidClickCount;
    }

    public Long getFinalShare() {
        return finalShare;
    }

    public void setFinalShare(Long finalShare) {
        this.finalShare = finalShare;
    }

    public Integer getIsOffline() {
        return isOffline;
    }

    public void setIsOffline(Integer isOffline) {
        this.isOffline = isOffline;
    }

    public Long getOfflineMoney() {
        return offlineMoney;
    }

    public void setOfflineMoney(Long offlineMoney) {
        this.offlineMoney = offlineMoney;
    }

    public Long getActExposeCount() {
        return actExposeCount;
    }

    public void setActExposeCount(Long actExposeCount) {
        this.actExposeCount = actExposeCount;
    }

    public Long getActClickCount() {
        return actClickCount;
    }

    public void setActClickCount(Long actClickCount) {
        this.actClickCount = actClickCount;
    }

    public Long getSdkUv() {
        return sdkUv;
    }

    public void setSdkUv(Long sdkUv) {
        this.sdkUv = sdkUv;
    }

    public Long getAdvertRequestCount() {
        return advertRequestCount;
    }

    public void setAdvertRequestCount(Long advertRequestCount) {
        this.advertRequestCount = advertRequestCount;
    }

    public Double getLaunchSuccessRate() {
        return launchSuccessRate;
    }

    public void setLaunchSuccessRate(Double launchSuccessRate) {
        this.launchSuccessRate = launchSuccessRate;
    }

    public Double getMediaCPM() {
        return mediaCPM;
    }

    public void setMediaCPM(Double mediaCPM) {
        this.mediaCPM = mediaCPM;
    }

    public Double getMediaCPC() {
        return mediaCPC;
    }

    public void setMediaCPC(Double mediaCPC) {
        this.mediaCPC = mediaCPC;
    }

    public Double getMediaUVPrice() {
        return mediaUVPrice;
    }

    public void setMediaUVPrice(Double mediaUVPrice) {
        this.mediaUVPrice = mediaUVPrice;
    }

    public Double getDivisionProportion() {
        return divisionProportion;
    }

    public void setDivisionProportion(Double divisionProportion) {
        this.divisionProportion = divisionProportion;
    }

    public Double getActualProportion() {
        return actualProportion;
    }

    public void setActualProportion(Double actualProportion) {
        this.actualProportion = actualProportion;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }
    
    public Integer getAccountType() {
        return accountType;
    }

    
    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }
    
    public Long getAdjustmentAmount() {
        return adjustmentAmount;
    }

    
    public void setAdjustmentAmount(Long adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
    }
    
    public Integer getTaxRate() {
        return taxRate;
    }

    
    public void setTaxRate(Integer taxRate) {
        this.taxRate = taxRate;
    }
    
    public String getGmtCreate() {
        return gmtCreate;
    }

    
    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
    
    public String getCurrentDate() {
        return currentDate;
    }

    
    public void setCurrentDate(String currentDate) {
        this.currentDate = currentDate;
    }
    public Long getHzFinalShare() {
        return hzFinalShare;
    }

    
    public void setHzFinalShare(Long hzFinalShare) {
        this.hzFinalShare = hzFinalShare;
    }

    
    public Long getHegsFinalShare() {
        return hegsFinalShare;
    }

    
    public void setHegsFinalShare(Long hegsFinalShare) {
        this.hegsFinalShare = hegsFinalShare;
    }
    
    public Long getHegsAdConsume() {
        return hegsAdConsume;
    }

    public void setHegsAdConsume(Long hegsAdConsume) {
        this.hegsAdConsume = hegsAdConsume;
    }

    public Long getHzAdConsume() {
        return hzAdConsume;
    }

    public void setHzAdConsume(Long hzAdConsume) {
        this.hzAdConsume = hzAdConsume;
    }

    public Long getHzConsumeTotal() {
        return hzConsumeTotal;
    }

    public void setHzConsumeTotal(Long hzConsumeTotal) {
        this.hzConsumeTotal = hzConsumeTotal;
    }

    public Long getHegsConsumeTotal() {
        return hegsConsumeTotal;
    }

    public void setHegsConsumeTotal(Long hegsConsumeTotal) {
        this.hegsConsumeTotal = hegsConsumeTotal;
    }

    public Long getHzExConsumeTotal() {
        return hzExConsumeTotal;
    }

    public void setHzExConsumeTotal(Long hzExConsumeTotal) {
        this.hzExConsumeTotal = hzExConsumeTotal;
    }

    public Long getHegsExConsumeTotal() {
        return hegsExConsumeTotal;
    }

    public void setHegsExConsumeTotal(Long hegsExConsumeTotal) {
        this.hegsExConsumeTotal = hegsExConsumeTotal;
    }

    /**
     * 组装待结算月账单，结算审核，已结算月账单
     *
     * @return
     */
    public List<String> installHidFileds(Integer flag) {
        String dest=null;
        List<String> destList=Lists.newArrayList();
        // 媒体待结算月账单
        //媒体CPM、媒体CPC、媒体UV单价、媒体预计收入、霍尔果斯预计收入、杭州预计收入、媒体应得收入、霍尔果斯应得收入、杭州应得收入、分成比例
        if (flag==AccountSettlementDto.SETTLEMENTS_STATUS_AWAITING) {
            dest=StringTool.join("mediaCPM","mediaCPC","mediaUVPrice","preShare","hegsExConsumeTotal","hzExConsumeTotal","justlyShare","hegsConsumeTotal","hzConsumeTotal","divisionProportion");
        }
        // 结算中月账单
        //媒体CPM、媒体CPC、媒体UV单价、媒体预计收入、霍尔果斯预计收入、杭州预计收入、媒体应得收入、霍尔果斯应得收入、杭州应得收入、分成比例
        if (flag==AccountSettlementDto.SETTLEMENT_STATUS_DEFAULT) {
            dest=StringTool.join("mediaCPM","mediaCPC","mediaUVPrice","preShare","hegsExConsumeTotal","hzExConsumeTotal","justlyShare","hegsConsumeTotal","hzConsumeTotal","divisionProportion");
        }
        //已结算月账单
        //媒体预计收入、媒体应得收入、调整分成金额、媒体实际分成 、霍尔果斯媒体实际收入 、杭州媒体实际收入 、分成比例、实际分成比例、平台利润
        if (flag==AccountSettlementDto.SETTLEMENT_STATUS_PASS) {
            dest=StringTool.join("preShare","justlyShare","adjustmentAmount","finalShare","hegsConsumeTotal","hzConsumeTotal","divisionProportion","actualProportion","platformProfit");
        }
        if (Objects.nonNull(dest)){
            return StringTool.getStringListByStr(dest);
        }
        return destList;
    }
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
