/**
 * Project Name:media-api File Name:ReqMediaAppStatusDto.java Package Name:cn.com.duiba.tuia.media.api.dto.req
 * Date:2016年10月19日下午8:31:13 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:ReqMediaAppStatusDto <br/>
 * Function: 修改媒体app状态Dto. <br/>
 * Date: 2016年10月19日 下午8:31:13 <br/>
 * 
 * @author guyan
 * @see
 */
@ApiModel
public class ReqUpdateMediaAppStatusDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID     = -7823268451467834867L;

    /** 修改成功标识 */
    public static final int   UPDATE_SUCCESS       = 1;

    /** 开通状态:0-待审核. */
    public static final int   MEDIA_APP_CHECKING   = 0;
    /** 开通状态:1-审核通过. */
    public static final int   MEDIA_APP_CHECK_PASS = 1;
    /** 开通状态:2-审核拒绝. */
    public static final int   MEDIA_APP_CHECK_FAIL = 2;
    /** 开通状态:3-待风控审核. */
    public static final int   MEDIA_RISK_CHECK = 3;

    /** 媒体Id */
    @ApiModelProperty(value = "媒体Id", required = true)
    @NotNull(message = "媒体Id不能为空")
    private Long              appId;

    /** 媒体审核状态 */
    @ApiModelProperty(value = "媒体审核状态", required = true)
    private Integer           checkStatus;

    /** 拒绝审核理由 */
    @ApiModelProperty(value = "拒绝审核理由", required = true)
    private String             refuseMsg;
    
    /**媒体冻结状态*/
    @ApiModelProperty(value = "媒体冻结状态", required = true)
    private Integer            isFrozen;
    
    @ApiModelProperty(value = "媒体冻结原因", required = true)
    private String            frozenReason;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }
    
    
    public Integer getIsFrozen() {
        return isFrozen;
    }

    
    public void setIsFrozen(Integer isFrozen) {
        this.isFrozen = isFrozen;
    }
    
    public String getFrozenReason() {
        return frozenReason;
    }

    public void setFrozenReason(String frozenReason) {
        this.frozenReason = frozenReason;
    }

    public String getRefuseMsg() {
        return refuseMsg;
    }

    public void setRefuseMsg(String refuseMsg) {
        this.refuseMsg = refuseMsg;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
