/**
 * Project Name:ssp-center-api File Name:RewardScoreBase.java Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年11月15日上午10:54:17 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.NumberFormat;

import java.io.Serializable;

/**
 * ClassName:RewardScoreBase <br/>
 * Date: 2017年11月15日 上午10:54:17 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class RewardScoreBase implements Serializable {
    private static final long serialVersionUID = -5257107057480474627L;
    //质量分
    @ApiModelProperty(value = "质量分")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Double quality;
    //量级分
    @ApiModelProperty(value = "量级分")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Double level;
    //流量类型分
    @ApiModelProperty(value = "流量类型分")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Double flow;

    @ApiModelProperty(value = "稳定性得分")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Double stable;

    @ApiModelProperty(value = "真实性得分")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Double truth;

    //一线城市加分
    @ApiModelProperty(value = "一线城市加分")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Double firstTierCity;
    //ios加分
    @ApiModelProperty(value = "ios加分")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Double ios;

    @ApiModelProperty(value = "适用规则")
    private RewardStrategyDto rsd;

    public RewardStrategyDto getRsd() {
        return rsd;
    }

    public void setRsd(RewardStrategyDto rsd) {
        this.rsd = rsd;
    }

    public Double getQuality() {
        return quality;
    }

    public void setQuality(Double quality) {
        this.quality = quality;
    }

    public Double getLevel() {
        return level;
    }

    public void setLevel(Double level) {
        this.level = level;
    }

    public Double getFlow() {
        return flow;
    }

    public void setFlow(Double flow) {
        this.flow = flow;
    }

    public Double getFirstTierCity() {
        return firstTierCity;
    }

    public void setFirstTierCity(Double firstTierCity) {
        this.firstTierCity = firstTierCity;
    }

    public Double getIos() {
        return ios;
    }

    public void setIos(Double ios) {
        this.ios = ios;
    }

    public Double getStable() {
        return stable;
    }

    public void setStable(Double stable) {
        this.stable = stable;
    }

    public Double getTruth() {
        return truth;
    }

    public void setTruth(Double truth) {
        this.truth = truth;
    }
}
