package cn.com.duiba.tuia.ssp.center.api.remote.advertselect.media;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.advertselect.SlotShieldPageQuery;
import cn.com.duiba.tuia.ssp.center.api.dto.advertselect.SlotShieldStrategyDto;
import cn.com.duiba.tuia.ssp.center.api.dto.advertselect.TagInfoDto;

import java.util.List;

/**
 * 〈一句话功能简述〉<br>
 * Description: 查询广告信息接口
 *
 * @author hillchen
 * @create 2018/10/24 16:16
 */
@AdvancedFeignClient
public interface RemoteSlotStrategyService {

    /**
     * 分页查询广告位屏蔽策略
     * @param slotShieldPageQuery
     * @return
     */
    PageResultDto<SlotShieldStrategyDto> findSlotShieldStrategyList(SlotShieldPageQuery slotShieldPageQuery);


    /**
     * 根据广告位屏蔽策略查询所有所有可见标签统计信息
     * @param slotStrategyId
     * @return
     */
    List<TagInfoDto> findAllTags(Long slotStrategyId);

}