package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.constant.PrePayStatus;
import cn.com.duiba.tuia.ssp.center.api.dto.PageDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PrePayDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqPrePayPage;

@AdvancedFeignClient
public interface RemotePrePayService {

    /**
     * 查询某个月的预付款金额
     * 
     * @param gmtCreate 格式yyyy-mm
     * @return
     */
    Long getPrePayAmountByMonth(String gmtCreate,Long appId);

    /**
     * 查询账号下所有未抵扣已打款的账单
     * @param mediaId
     * @return
     */
    List<PrePayDto> selectPrePayAmountByMediaId(Long mediaId);

    PageDto<PrePayDto> getPrePayList(ReqPrePayPage req);

    Integer updateStatus(PrePayStatus nowStatus, PrePayStatus nextStatus, Long orderId, String rejectReason);

    Integer insert(PrePayDto req);
    /** 查询媒体下所有的预付款单 */
    Integer selectCountByMediaId(Long mediaId);

    /** 分页查询媒体下预付款单 */
    List<PrePayDto> selectPageListByMediaId(Long mediaId, Integer start, Integer limit);

    List<PrePayDto> selectByCashOrderId(Long cashOrderId);

    Long selectPrePayBalance(Long appId);
}
