/**
 * Project Name:ssp-center-api
 * File Name:ReqMaterialActStatistics.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年7月12日下午3:51:36
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqMaterialActStatistics <br/>
 * Function: 素材活动数据. <br/>
 * Date:     2017年7月12日 下午3:51:36 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ReqMaterialActStatistics extends ReqMaterialStatisticsBase{

    /**序列号*/
    private static final long serialVersionUID = -3497988027059361996L;

    /**活动名称*/
    @ApiModelProperty(value = "活动名称", required = false)
    private String activityName;
    
    /**活动ids*/
    @ApiModelProperty(value = "活动ids", required = false)
    private List<Long> activityIds; 
    
    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }
    
    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }
    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}

