package cn.com.duiba.tuia.ssp.center.api.remote.risk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.risk.RpsTagsDto;

import java.util.List;
import java.util.Map;

/**
 * 提供风控系统调用接口
 * @author fangzhipeng
 * @date 2018/8/30
 */
@AdvancedFeignClient
public interface RemoteRiskService {

    /**
     * 根据appIds获取四类标签
     *  - 行业标签
     *      - 使用工具
     *          - 浏览器
     *  - 流量标签
     *      - 腾讯系
     *          - 公众号
     *  - 流量分级标签
     *      - 一级流量
     *          - 陌陌竞价
     *  - 风险标签
     *      - 媒体资料异常
     *          - 无明显广告位入口
     *      - 媒体黑名单
     *          - 存在多次作弊行为
     *  注意list中严格按照 行业标签 流量标签 流量分级标签 风险标签顺序返回
     *  媒体本身没有该类型标签的要new RpsTagsDto 对象出来，child 为空
     */
    Map<Long, List<RpsTagsDto>> get4Tags(List<Long> appIds);


    /**
     * 根据slotIds获取结算方式, 核对了下风控目前只需要长期稳定的结算方式
     * 0-分成;1-CPC;2-CPM;3-UV单价,4-cpt
     * @param slotIds
     * @return
     */
    Map<Long, Integer> getSettlementMethods(List<Long> slotIds);


    /**
     * 获取所有媒体的行业标签
     *
     * @return
     */
    Map<Long, RpsTagsDto> getAppIndustryTag();

}
