package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Function: 媒体定制活动排序查询条件
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
@ApiModel
public class ReqActivitySort extends BaseQueryDto implements Serializable {

    private static final long serialVersionUID = -4243315336347406227L;

    /** 活动类型 */
    @ApiModelProperty(value = "活动类型", required = false)
    private Integer           type;

    /** 活动ID */
    @ApiModelProperty(value = "活动ID", required = false)
    private Long              id;

    /** 活动名称 */
    @ApiModelProperty(value = "活动名称", required = false)
    private String            name;

    /** 活动媒体ID */
    @ApiModelProperty(value = "活动媒体ID", required = false)
    private Long              appId;
    
    /** 广告位ID */
    @ApiModelProperty(value = "广告位ID", required = false)
    private Long              slotId;

    /** 活动ID列表 */
    private List<Long>        activityIds;
    
    /** 活动来源 0：兑吧活动 ；1：推啊活动；2：流量引导页 */
    private Integer           source;
    
    /** 是否是活动组  */
    private Boolean isActGroup;
    
    /**素材ID*/
    private Long msId;
    
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }

    
    public Integer getSource() {
        return source;
    }

    
    public void setSource(Integer source) {
        this.source = source;
    }

	public Boolean getIsActGroup() {
		return isActGroup;
	}

	public void setIsActGroup(Boolean isActGroup) {
		this.isActGroup = isActGroup;
	}
	
	public Long getMsId() {
        return msId;
    }
    
    public void setMsId(Long msId) {
        this.msId = msId;
    }

}
