package cn.com.duiba.tuia.ssp.center.api.remote.interflow.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * Description: 推啊媒体维度实时数据对象
 *
 * @author hillchen
 * @create 2018/11/14 22:35
 */
public class TuiaAppDiDto implements Serializable {
    private static final long serialVersionUID = -4612563710255883569L;
    //应用id
    private Long appId;
    //广告位访问PV
    private Long sdkPv;
    //广告位访问UV
    private Long sdkUv;
    //活动请求PV
    private Long actRequestCount;
    //活动请求UV
    private Long actRequestUv;
    //活动参与PV
    private Long participateCount;
    //活动参与UV
    private Long participateUv;
    //广告位请求成功PV
    private Long actSucResponseCount;
    //广告位曝光PV
    private Long actExposeCount;
    //广告位点击PV
    private Long actClickCount;
    //广告位点击UV
    private Long actClickUv;
    //活动广告发券量
    private Long launchCount;
    //广告券点击PV
    private Long advertClickCount;
    //广告券曝光PV
    private Long advertExposureCount;
    //活动广告券请求PV
    private Long advertRequestCount;
    //广告消耗
    private Long advertFee;
    //开始统计时间
    private Long startTime;
    //结束统计时间
    private Long finishTime;
    //当前日期
    private Long curDate;
    //广告位曝光uv
    private Long actExposeUv;
    //付费券发券量 计费点击日志中,点击单价＞0的广告对应的发券量
    private Long payLaunchPv;
    //付费券曝光量 计费点击日志中,点击单价＞0的广告对应的曝光量
    private Long payExposurePv;
    //付费券计费点击量计费点击日志中,点击单价＞0的广告对应的计费点击量
    private Long payEfClicks;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getSdkPv() {
        return sdkPv;
    }

    public void setSdkPv(Long sdkPv) {
        this.sdkPv = sdkPv;
    }

    public Long getSdkUv() {
        return sdkUv;
    }

    public void setSdkUv(Long sdkUv) {
        this.sdkUv = sdkUv;
    }

    public Long getActRequestCount() {
        return actRequestCount;
    }

    public void setActRequestCount(Long actRequestCount) {
        this.actRequestCount = actRequestCount;
    }

    public Long getActRequestUv() {
        return actRequestUv;
    }

    public void setActRequestUv(Long actRequestUv) {
        this.actRequestUv = actRequestUv;
    }

    public Long getParticipateCount() {
        return participateCount;
    }

    public void setParticipateCount(Long participateCount) {
        this.participateCount = participateCount;
    }

    public Long getParticipateUv() {
        return participateUv;
    }

    public void setParticipateUv(Long participateUv) {
        this.participateUv = participateUv;
    }

    public Long getActSucResponseCount() {
        return actSucResponseCount;
    }

    public void setActSucResponseCount(Long actSucResponseCount) {
        this.actSucResponseCount = actSucResponseCount;
    }

    public Long getActExposeCount() {
        return actExposeCount;
    }

    public void setActExposeCount(Long actExposeCount) {
        this.actExposeCount = actExposeCount;
    }

    public Long getActClickCount() {
        return actClickCount;
    }

    public void setActClickCount(Long actClickCount) {
        this.actClickCount = actClickCount;
    }

    public Long getActClickUv() {
        return actClickUv;
    }

    public void setActClickUv(Long actClickUv) {
        this.actClickUv = actClickUv;
    }

    public Long getLaunchCount() {
        return launchCount;
    }

    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    public Long getAdvertClickCount() {
        return advertClickCount;
    }

    public void setAdvertClickCount(Long advertClickCount) {
        this.advertClickCount = advertClickCount;
    }

    public Long getAdvertExposureCount() {
        return advertExposureCount;
    }

    public void setAdvertExposureCount(Long advertExposureCount) {
        this.advertExposureCount = advertExposureCount;
    }

    public Long getAdvertRequestCount() {
        return advertRequestCount;
    }

    public void setAdvertRequestCount(Long advertRequestCount) {
        this.advertRequestCount = advertRequestCount;
    }

    public Long getAdvertFee() {
        return advertFee;
    }

    public void setAdvertFee(Long advertFee) {
        this.advertFee = advertFee;
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Long finishTime) {
        this.finishTime = finishTime;
    }

    public Long getCurDate() {
        return curDate;
    }

    public void setCurDate(Long curDate) {
        this.curDate = curDate;
    }

    public Long getActExposeUv() {
        return actExposeUv;
    }

    public void setActExposeUv(Long actExposeUv) {
        this.actExposeUv = actExposeUv;
    }

    public Long getPayLaunchPv() {
        return payLaunchPv;
    }

    public void setPayLaunchPv(Long payLaunchPv) {
        this.payLaunchPv = payLaunchPv;
    }

    public Long getPayExposurePv() {
        return payExposurePv;
    }

    public void setPayExposurePv(Long payExposurePv) {
        this.payExposurePv = payExposurePv;
    }

    public Long getPayEfClicks() {
        return payEfClicks;
    }

    public void setPayEfClicks(Long payEfClicks) {
        this.payEfClicks = payEfClicks;
    }

    /**
     * 计算媒体arpu值 广告位消耗/广告位uv
     * @return
     */
    public Long computeArpu(){
        if (Objects.isNull(sdkUv) || sdkUv==0){
            return 0L;
        }
        return BigDecimal.valueOf(advertFee)
                .divide(BigDecimal.valueOf(sdkUv),4, BigDecimal.ROUND_HALF_UP)
                .multiply(BigDecimal.valueOf(10000))
                .longValue();
    }

    /**
     * 计算媒体cvr值 广告券发券量/广告位点击数
     * @return
     */
    public Long computeCvr(){
        if (Objects.isNull(actClickCount) || actClickCount==0){
            return 0L;
        }
        return BigDecimal.valueOf(advertClickCount)
                .divide(BigDecimal.valueOf(actClickCount),4, BigDecimal.ROUND_HALF_UP)
                .multiply(BigDecimal.valueOf(10000))
                .longValue();
    }

    /**
     * 计算媒体免费券曝光占比 （广告券发券量 - 付费券发券量）/广告券发券量
     * @return
     */
    public Long computeFreeRadio(){
        if (Objects.isNull(advertClickCount) || advertClickCount==0){
            return 0L;
        }
        return BigDecimal.valueOf(advertClickCount - payLaunchPv)
                .divide(BigDecimal.valueOf(advertClickCount),4, BigDecimal.ROUND_HALF_UP)
                .multiply(BigDecimal.valueOf(10000))
                .longValue();
    }

    public Long computeUvProfit(){
        if (Objects.isNull(sdkUv) || sdkUv==0){
            return 0L;
        }
        return BigDecimal.valueOf(advertFee)
                .divide(BigDecimal.valueOf(sdkUv),4, BigDecimal.ROUND_HALF_UP)
                .multiply(BigDecimal.valueOf(10000))
                .longValue();
    }


}