/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.econtract.util;

import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.BestsignRequestResult;
import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.BestsignRequestStringResult;
import cn.com.duiba.tuia.ssp.center.api.econtract.exception.BestsignResultErrorException;
import cn.com.duiba.tuia.ssp.center.api.econtract.util.BestsignPropertie;
import cn.com.duiba.tuia.ssp.center.api.econtract.util.RSAUtils;
import cn.com.duiba.tuia.ssp.center.api.econtract.util.RestRequestUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class BestsignOpenApiClient {
    private static String baseUrlParams = "developerId=%s&rtick=%s&signType=rsa";

    public static <T> T getRequest(BestsignPropertie bestsignPropertie, String path, Map<String, String> params, Class<T> responseType) {
        String rtick = RSAUtils.getRtick();
        String urlParams = BestsignOpenApiClient.createUrlParams(bestsignPropertie, params, rtick);
        String paramsSign = RSAUtils.calcRsaSignNoEncode(bestsignPropertie.getDeveloperId(), bestsignPropertie.getPrivateKey(), bestsignPropertie.getServerHost(), path, rtick, urlParams, null);
        String requestUrl = urlParams + "&sign=" + paramsSign;
        return RestRequestUtil.sendHttpGet(bestsignPropertie.getServerHost(), path, requestUrl, responseType);
    }

    public static <T> BestsignRequestResult<T> postBestRequest(BestsignPropertie bestsignPropertie, String path, String sendData, Class<T> responseType) throws BestsignResultErrorException {
        BestsignRequestResult<T> result = BestsignOpenApiClient.buildResult(BestsignOpenApiClient.postRequest(bestsignPropertie, path, sendData), responseType);
        BestsignOpenApiClient.checkResult(result);
        return result;
    }

    public static String postRequest(BestsignPropertie bestsignPropertie, String path, String sendData) {
        return BestsignOpenApiClient.postRequest(bestsignPropertie, path, sendData, String.class);
    }

    public static <T> T postRequest(BestsignPropertie bestsignPropertie, String path, String sendData, Class<T> responseType) {
        String rtick = "15476532244940";
        String urlParams = BestsignOpenApiClient.createUrlParams(bestsignPropertie, null, rtick);
        String paramsSign = RSAUtils.calcRsaSignNoEncode(bestsignPropertie.getDeveloperId(), bestsignPropertie.getPrivateKey(), bestsignPropertie.getServerHost(), path, rtick, null, sendData);
        String requestUrl = urlParams + "&sign=" + paramsSign;
        return RestRequestUtil.sendHttpPost(bestsignPropertie.getServerHost(), path, requestUrl, sendData, responseType);
    }

    private static <T> BestsignRequestResult<T> buildResult(String resultBody, Class<T> dataType) {
        BestsignRequestStringResult bestsignRequestStringResult;
        if (StringUtils.isNotBlank((CharSequence)resultBody) && (bestsignRequestStringResult = (BestsignRequestStringResult)JSONObject.parseObject((String)resultBody, BestsignRequestStringResult.class)) != null) {
            return bestsignRequestStringResult.convert(dataType);
        }
        return null;
    }

    private static String createUrlParams(BestsignPropertie bestsignPropertie, Map<String, String> params, String rtick) {
        String baseUrl = String.format(baseUrlParams, bestsignPropertie.getDeveloperId(), rtick);
        StringBuilder urlParamsBuilder = new StringBuilder("?");
        urlParamsBuilder.append(baseUrl);
        if (!CollectionUtils.isEmpty(params)) {
            params.forEach((key, value) -> urlParamsBuilder.append("&").append((String)key).append("=").append((String)value));
        }
        return urlParamsBuilder.toString();
    }

    public static void checkResult(BestsignRequestResult bestsignRequestResult) throws BestsignResultErrorException {
        if (bestsignRequestResult == null) {
            throw new BestsignResultErrorException("\u4e0a\u4e0a\u7b7e\u7ed3\u679c\u54cd\u5e94\u5f02\u5e38");
        }
        if (!bestsignRequestResult.succResult()) {
            throw new BestsignResultErrorException(bestsignRequestResult.getErrmsg());
        }
    }
}

