package cn.com.duiba.tuia.ssp.center.api.econtract.service;

import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.*;
import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.contract.*;
import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.payauth.*;
import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.realname.*;
import cn.com.duiba.tuia.ssp.center.api.econtract.exception.BestsignResultErrorException;

/**
 * 〈一句话功能简述〉<br>
 * Description: 上上签请求服务接口
 *
 * @author hillchen
 * @create 2019/1/17 13:51
 */
public interface BestsignReqService {
    /**
     * 企业三要素验证
     * @param entThreeElements
     * @return
     */
    BestsignRequestResult<CheckResult> checkEntThreeElements(EntThreeElements entThreeElements)throws BestsignResultErrorException;


    /**
     * 个人三要素验证并发送短信验证码
     * @param personalTowElements
     * @return
     */
    BestsignRequestResult<CheckResult> checkPersonalTowElements(PersonalTowElements personalTowElements)throws BestsignResultErrorException;

    /**
     * 个人三要素验证并发送短信验证码
     * @param personalThreeElements
     * @return
     */
    BestsignRequestResult<PersonalVcodeResult> personalVcodeSender(PersonalThreeElements personalThreeElements)throws BestsignResultErrorException;

    /**
     * 个人手机号三要素及验证码校验
     * @param vcodeCheckReq
     * @return
     */
    BestsignRequestResult<CheckResult> personalVcodeCheck(VcodeCheckReq vcodeCheckReq)throws BestsignResultErrorException;

    /**
     * 发起企业打款请求认证
     * @param payAuthReq
     * @return
     */
    BestsignRequestResult<PayAuthResult> payAuthRequset(PayAuthReq payAuthReq)throws BestsignResultErrorException;

    /**
     * 企业打款应答验证
     * @param payAuthVerifyReq
     * @return
     */
    BestsignRequestResult<CheckResult> payAuthVerify(PayAuthVerifyReq payAuthVerifyReq)throws BestsignResultErrorException;

    /**
     * 企业打款认证状态查询
     * @param payAuthQueryReq
     * @return
     */
    BestsignRequestResult<PayAuthStatus> payAuthQuery(PayAuthQueryReq payAuthQueryReq)throws BestsignResultErrorException;

    /**
     * 注册企业用户并申请证书
     * @param userRegReq
     * @return
     */
    BestsignRequestResult<UserRegResult> userReg(UserRegReq userRegReq)throws BestsignResultErrorException;

    /**
     * 异步申请状态查询
     * @param userRegStatusReq
     * @return
     */
    BestsignRequestResult<UserRegStatus> queryUserRegStatus(UserRegStatusReq userRegStatusReq)throws BestsignResultErrorException;

    /**
     * 生成用户签名/印章图片
     * bestsignBaseReq
     * @param bestsignBaseReq
     * @return
     */
    BestsignRequestResult<String> createSeal(BestsignBaseReq bestsignBaseReq)throws BestsignResultErrorException;


    /**
     * 预览模版
     * @param previewContractTemplateReq
     * @return
     */
    BestsignRequestResult<UrlResult> previewContractTemplate(PreviewContractTemplateReq previewContractTemplateReq)throws BestsignResultErrorException;

    /**
     * 通过模版生成合同文件
     * @param createPdfByTemplateReq
     * @return
     */
    BestsignRequestResult<CreatePdfByTemplateResult> createPdfByTemplate(CreatePdfByTemplateReq createPdfByTemplateReq)throws BestsignResultErrorException;


    /**
     * 通过模版创建合同
     * @param createByTemplateReq
     * @return
     */
    BestsignRequestResult<CreateContractResult> createByTemplate(CreateByTemplateReq createByTemplateReq)throws BestsignResultErrorException;

    /**
     * 用模版变量的手动签
     * @param sendByTemplateReq
     * @return
     */
    BestsignRequestResult<SendContractResult> sendByTemplate(SendByTemplateReq sendByTemplateReq)throws BestsignResultErrorException;

    /**
     * 锁定并结束合同
     * @param contractLockReq
     * @return
     */
    BestsignRequestResult<String> contractLock(ContractLockReq contractLockReq)throws BestsignResultErrorException;

    /**
     * 获取合同预览页URL
     * @param previewURLReq
     * @return
     */
    BestsignRequestResult<UrlResult> previewURL(PreviewURLReq previewURLReq)throws BestsignResultErrorException;


}