package cn.com.duiba.tuia.ssp.center.api.econtract.service;

import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.*;
import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.contract.*;
import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.payauth.*;
import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.realname.*;
import cn.com.duiba.tuia.ssp.center.api.econtract.exception.BestsignResultErrorException;
import cn.com.duiba.tuia.ssp.center.api.econtract.util.BestsignOpenApiClient;
import cn.com.duiba.tuia.ssp.center.api.econtract.util.BestsignPropertie;
import com.alibaba.fastjson.JSONObject;

/**
 * 〈一句话功能简述〉<br>
 * Description: 上上签服务实现类
 *
 * @author hillchen
 * @create 2019/1/17 14:06
 */
public class SimpleBestsignReqService implements BestsignReqService {
    /**
     * 企业三要素验证url相对地址
     */
    private static final String URL_ENT_IDENTITY3 = "/credentialVerify/enterprise/identity3";
    private static final String URL_PERSONAL_VCODE = "/realName/personal/identity3/vcode/sender";
    private static final String URL_PERSONAL_VCODE_CHECK = "/realName/personal/identity3/vcode/verify";
    private static final String URL_PERSONAL_IDENTITY2 = "/credentialVerify/personal/identity2";
    /**
     * 企业打款认证地址
     */
    private static final String URL_PAYAUTH = "/credentialVerify/enterprise/payAuth";

    /**
     * 企业打款认证验证地址
     */
    private static final String URL_PAYAUTH_VERIFY = "/credentialVerify/enterprise/payAuthVerify";
    /**
     * 企业打款认证状态查询地址
     */
    private static final String URL_PAYAUTH_QUERY = "/credentialVerify/enterprise/payAuthQuery";

    /**
     * 企业用户注册地址
     */
    private static final String URL_USER_REG = "/user/reg/";
    /**
     * 企业用户注册申请状态查询地址
     */
    private static final String URL_USER_REG_STATUS_QUERY = "/user/async/applyCert/status/";
    /**
     * 企业用户生成默认印章请求地址
     */
    private static final String URL_USER_CREATE_SEAL = "/signatureImage/user/create/";
    /**
     * 获取预览合同模板地址接口
     */
    private static final String URL_CONTRACT_TEMPLATE_PREVIEW  = "/page/template/preview/";
    /**
     * 根据合同模板创建合同问题地址
     */
    private static final String URL_CONTRACT_CREATEPDF_BYTEMPLATE  = "/template/createContractPdf/";
    /**
     * 通过模版创建合同
     */
    private static final String URL_CONTRACT_CREATE_BYTEMPLATE  = "/contract/createByTemplate/";
    /**
     * 用模版变量的手动签
     */
    private static final String URL_CONTRACT_SEND_BYTEMPLATE  = "/contract/sendByTemplate/";
    /**
     * 锁定并结束合同
     */
    private static final String URL_CONTRACT_LOCK  = "/storage/contract/lock/";
    /**
     * 获取预览页URL
     */
    private static final String URL_CONTRACT_PREVIEW  = "/contract/getPreviewURL/";


    private BestsignPropertie bestsignPropertie;

    public SimpleBestsignReqService(BestsignPropertie bestsignPropertie) {
        this.bestsignPropertie = bestsignPropertie;
    }

    private <T> BestsignRequestResult<T> requestPost(Object requestData,String path,Class<T> resultType)throws BestsignResultErrorException {
        String sendData = JSONObject.toJSONString(requestData);
        return BestsignOpenApiClient.postBestRequest(bestsignPropertie,path,sendData,resultType);
    }


    @Override
    public BestsignRequestResult<CheckResult> checkEntThreeElements(EntThreeElements entThreeElements) throws BestsignResultErrorException{
        return requestPost(entThreeElements,URL_ENT_IDENTITY3,CheckResult.class);
    }

    @Override
    public BestsignRequestResult<CheckResult> checkPersonalTowElements(PersonalTowElements personalTowElements)throws BestsignResultErrorException{
        return requestPost(personalTowElements,URL_PERSONAL_IDENTITY2,CheckResult.class);
    }

    @Override
    public BestsignRequestResult<PersonalVcodeResult> personalVcodeSender(PersonalThreeElements personalThreeElements)throws BestsignResultErrorException {
        return requestPost(personalThreeElements,URL_PERSONAL_VCODE,PersonalVcodeResult.class);
    }

    @Override
    public BestsignRequestResult<CheckResult> personalVcodeCheck(VcodeCheckReq vcodeCheckReq) throws BestsignResultErrorException{
        return requestPost(vcodeCheckReq,URL_PERSONAL_VCODE_CHECK,CheckResult.class);
    }

    @Override
    public BestsignRequestResult<PayAuthResult> payAuthRequset(PayAuthReq payAuthReq) throws BestsignResultErrorException{
        return requestPost(payAuthReq,URL_PAYAUTH,PayAuthResult.class);
    }

    @Override
    public BestsignRequestResult<CheckResult> payAuthVerify(PayAuthVerifyReq payAuthVerifyReq) throws BestsignResultErrorException{
        return requestPost(payAuthVerifyReq,URL_PAYAUTH_VERIFY,CheckResult.class);
    }

    @Override
    public BestsignRequestResult<PayAuthStatus> payAuthQuery(PayAuthQueryReq payAuthQueryReq)throws BestsignResultErrorException {
        return requestPost(payAuthQueryReq,URL_PAYAUTH_QUERY,PayAuthStatus.class);
    }

    @Override
    public BestsignRequestResult<UserRegResult> userReg(UserRegReq userRegReq) throws BestsignResultErrorException{
        return requestPost(userRegReq,URL_USER_REG,UserRegResult.class);
    }

    @Override
    public BestsignRequestResult<UserRegStatus> queryUserRegStatus(UserRegStatusReq userRegStatusReq)throws BestsignResultErrorException {
        return requestPost(userRegStatusReq,URL_USER_REG_STATUS_QUERY,UserRegStatus.class);
    }

    @Override
    public BestsignRequestResult<String> createSeal(BestsignBaseReq bestsignBaseReq) throws BestsignResultErrorException{
        return requestPost(bestsignBaseReq,URL_USER_CREATE_SEAL,String.class);
    }

    @Override
    public BestsignRequestResult<UrlResult> previewContractTemplate(PreviewContractTemplateReq previewContractTemplateReq)throws BestsignResultErrorException {
        return requestPost(previewContractTemplateReq,URL_CONTRACT_TEMPLATE_PREVIEW,UrlResult.class);
    }

    @Override
    public BestsignRequestResult<CreatePdfByTemplateResult> createPdfByTemplate(CreatePdfByTemplateReq createPdfByTemplateReq) throws BestsignResultErrorException{
        return requestPost(createPdfByTemplateReq,URL_CONTRACT_CREATEPDF_BYTEMPLATE,CreatePdfByTemplateResult.class);
    }

    @Override
    public BestsignRequestResult<CreateContractResult> createByTemplate(CreateByTemplateReq createByTemplateReq)throws BestsignResultErrorException {
        return requestPost(createByTemplateReq,URL_CONTRACT_CREATE_BYTEMPLATE,CreateContractResult.class);
    }

    @Override
    public BestsignRequestResult<SendContractResult> sendByTemplate(SendByTemplateReq sendByTemplateReq) throws BestsignResultErrorException{
        return requestPost(sendByTemplateReq,URL_CONTRACT_SEND_BYTEMPLATE,SendContractResult.class);
    }

    @Override
    public BestsignRequestResult<String> contractLock(ContractLockReq contractLockReq)throws BestsignResultErrorException{
        return requestPost(contractLockReq,URL_CONTRACT_LOCK,String.class);
    }

    @Override
    public BestsignRequestResult<UrlResult> previewURL(PreviewURLReq previewURLReq)throws BestsignResultErrorException {
        return requestPost(previewURLReq,URL_CONTRACT_PREVIEW,UrlResult.class);
    }
}