/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.econtract.util;

import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestRequestUtil {
    private static final RestTemplate restTemplate = new RestTemplate();

    public static <T> T sendHttpGet(String host, String method, String urlParams, Class<T> responseType) {
        String requestUrl = host + method + urlParams;
        return RestRequestUtil.sendGet(requestUrl, responseType);
    }

    public static <T> T sendHttpPost(String host, String method, String urlParams, String sendData, Class<T> responseType) {
        String requestUrl = host + method + urlParams;
        return RestRequestUtil.sendPost(requestUrl, null, sendData, responseType);
    }

    public static <T> T sendPost(String url, Map<String, String> headers, Object sendData, Class<T> responseType) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (!CollectionUtils.isEmpty(headers)) {
            headers.forEach((key, value) -> httpHeaders.add(key, value));
        }
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        httpHeaders.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity httpEntity = new HttpEntity(sendData, (MultiValueMap)httpHeaders);
        return (T)restTemplate.postForObject(url, (Object)httpEntity, responseType, new Object[0]);
    }

    public static <T> T sendGet(String url, Map<String, ?> urlVariables, Class<T> responseType) {
        return (T)restTemplate.getForObject(url, responseType, urlVariables);
    }

    public static <T> T sendGet(String url, Class<T> responseType) {
        return (T)restTemplate.getForObject(url, responseType, new Object[0]);
    }
}

