/**
 * Project Name:media-api File Name:ReqDataStatisticsByPageDto.java Package Name:cn.com.duiba.tuia.media.api.dto.req
 * Date:2016年10月11日下午3:09:44 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * ClassName:ReqDataStatisticsByPageDto <br/>
 * Function: 结算数据统计. <br/>
 * Date: 2016年10月11日 下午3:09:44 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqSlotLineStatisticsByPageDto extends BaseQueryDto {

    /** 序列号 */
    private static final long  serialVersionUID = -5308774071126171980L;

    /** 以当前时间进行排序 */
    public static final String SORT_TYPE        = "cur_date";

    /** 升序排序 */
    public static final String ORDER_TYPE       = "asc";

    /**
     * 降序排序
     */
    public static final String ORDER_TYPE_DESC = "desc";
    
    /**查询app数据*/
    public static final Integer QUERY_APP_DATA       = 0;
    
    /**查询广告位数据*/
    public static final Integer QUERY_SLOT_DATA       = 1;
    
  
    /** 开始时间 */
    @ApiModelProperty(value = "开始时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private Date               startDate;

    /** 结束时间 */
    @ApiModelProperty(value = "结束时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private Date               endDate;

    /** 媒体用户ID */
    @ApiModelProperty(value = "媒体用户ID", required = false)
    private Long               mediaId;
    
    /** 媒体用户IDS */
    @ApiModelProperty(value = "媒体用户IDS", required = false)
    private List<Long>         mediaIds;

    /** 广告位id列表 */
    private List<Long>         slotIds;
    
    /** app_id列表 */
    private List<Long>         appIds;

    /**广告类型*/
    private Integer            slotType;
    
    /**数据类型*/
    private Integer            dateType;
    
    /**api查询日期*/
    @ApiModelProperty(value = "api查询日期", required = true)
    private Date               apiDate;

    /**
     * 媒体ID
     */
    private Long               appId;

    /**
     * 广告位Id
     */
    private Long               slotId;

    public ReqSlotLineStatisticsByPageDto() {
        super();
    }
    
    public ReqSlotLineStatisticsByPageDto(List<Long> mediaIds,List<Long> appIds, Date apiDate) {
        super();
        this.mediaIds = mediaIds;
        this.appIds = appIds;
        this.apiDate = apiDate;
    }
    
    public Integer getDateType() {
        return dateType;
    }

    
    public void setDateType(Integer dateType) {
        this.dateType = dateType;
    }

    public List<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public List<Long> getSlotIds() {
        return slotIds;
    }

    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }

    public Integer getSlotType() {
        return slotType;
    }

    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }
    
    public Date getApiDate() {
        return apiDate;
    }
    
    public void setApiDate(Date apiDate) {
        this.apiDate = apiDate;
    }
    
    public List<Long> getMediaIds() {
        return mediaIds;
    }
    
    public void setMediaIds(List<Long> mediaIds) {
        this.mediaIds = mediaIds;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }
}
