package cn.com.duiba.tuia.ssp.center.api.econtract.util;

import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.BestsignRequestResult;
import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.BestsignRequestStringResult;
import cn.com.duiba.tuia.ssp.center.api.econtract.exception.BestsignResultErrorException;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import java.util.Map;

/**
 * 上上签混合云SDK客户端
 */
public class BestsignOpenApiClient {

	private static String baseUrlParams = "developerId=%s&rtick=%s&signType=rsa";

	public static <T>T getRequest(BestsignPropertie bestsignPropertie, String path, Map<String,String> params,Class<T> responseType){
		// 生成一个时间戳参数
		String rtick = RSAUtils.getRtick();
		//生成url
		String urlParams = createUrlParams(bestsignPropertie,params,rtick);
		//生成签名
		String paramsSign = RSAUtils.calcRsaSignNoEncode(bestsignPropertie.getDeveloperId(),
				bestsignPropertie.getPrivateKey(), bestsignPropertie.getServerHost(), path, rtick, urlParams,
				null);
		//组装签名到url
		String requestUrl = urlParams  + "&sign=" + paramsSign;

		//调用请求并返回响应结果
		return RestRequestUtil.sendHttpGet(bestsignPropertie.getServerHost(),path,requestUrl,responseType);
	}


	public static <T> BestsignRequestResult<T>  postBestRequest(BestsignPropertie bestsignPropertie, String path, String sendData,Class<T> responseType)
			throws BestsignResultErrorException{
		BestsignRequestResult<T> result = buildResult(postRequest(bestsignPropertie,path,sendData),responseType);
		checkResult(result);
		return result;
	}

	public static String postRequest(BestsignPropertie bestsignPropertie, String path, String sendData){
		return postRequest(bestsignPropertie,path,sendData,String.class);
	}


	public static <T>T postRequest(BestsignPropertie bestsignPropertie, String path, String sendData,Class<T> responseType){
		// 生成一个时间戳参数
		String rtick = "15476532244940";//RSAUtils.getRtick();
		//生成url
		String urlParams = createUrlParams(bestsignPropertie,null,rtick);
		//生成签名
		String paramsSign = RSAUtils.calcRsaSignNoEncode(bestsignPropertie.getDeveloperId(),
				bestsignPropertie.getPrivateKey(), bestsignPropertie.getServerHost(), path, rtick, null,
				sendData);
		//组装签名到url
		String requestUrl = urlParams  + "&sign=" + paramsSign;

		//调用请求并返回响应结果
		return RestRequestUtil.sendHttpPost(bestsignPropertie.getServerHost(),path,requestUrl,sendData,responseType);
	}


	private static <T> BestsignRequestResult<T> buildResult(String resultBody, Class<T> dataType){
		if(StringUtils.isNotBlank(resultBody)){
			BestsignRequestStringResult bestsignRequestStringResult = JSONObject.parseObject(resultBody,BestsignRequestStringResult.class);
			if(bestsignRequestStringResult != null){
				return bestsignRequestStringResult.convert(dataType);
			}
		}
		return null;
	}

	private static String createUrlParams(BestsignPropertie bestsignPropertie,Map<String,String> params,String rtick){
		String baseUrl = String.format(baseUrlParams,bestsignPropertie.getDeveloperId(),rtick);

		StringBuilder urlParamsBuilder = new StringBuilder("?");
		urlParamsBuilder.append(baseUrl);
		if(!CollectionUtils.isEmpty(params)){
			params.forEach((key,value) -> urlParamsBuilder.append("&").append(key).append("=").append(value));
		}
		return urlParamsBuilder.toString();
	}

	public static void checkResult(BestsignRequestResult bestsignRequestResult) throws BestsignResultErrorException {
		if(bestsignRequestResult == null){
			throw new BestsignResultErrorException("上上签结果响应异常");
		} else if(!bestsignRequestResult.succResult()){
			throw new BestsignResultErrorException(bestsignRequestResult.getErrmsg());
		}
	}

}
