package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

//激励审核对象
@ApiModel
public class MediaRewardBillDto extends MediaRewardStrategyDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 待审核&拒绝后重新审核
     **/
    public static int SETTLE_STATUS_WAIT = 0;

    /**
     * 待媒体运营负责人审核
     **/
    public static int SETTLE_STATUS_MEDIA = 1;

    /**
     * 待流量负责人审核
     **/
    public static int SETTLE_STATUS_FLOW = 2;

    /**
     * 待风控审核人审核
     **/
    public static int SETTLE_STATUS_RISK = 4;

    /**
     * 审核通过
     **/
    public static int SETTLE_STATUS_PASS = 3;

    //主键id
    @ApiModelProperty(value = "ID")
    private Long id;

    //规则id
    @ApiModelProperty(value = "规则ID")
    private Long mrsId;

    //媒体帐号邮箱
    @ApiModelProperty(value = "媒体帐号邮箱", required = false)
    private String email;

    //预计得分
    @ApiModelProperty(value = "预计得分", required = false)
    private Double predictScore;

    //实际得分
    @ApiModelProperty(value = "实际得分", required = false)
    private Double realScore;

    //预计激励（单位：分）
    @ApiModelProperty(value = "预计激励（单位：分）", required = false)
    private Long predictReward;

    //实际激励（单位：分）
    @ApiModelProperty(value = "实际激励（单位：分）", required = false)
    private Long realReward;

    //实际收入（单位：分）
    @ApiModelProperty(value = "实际收入（单位：分）", required = false)
    private Long realIncome;

    //实际激励（单位：分）
    @ApiModelProperty(value = "实际激励-霍1（单位：分）", required = false)
    private Long hegsRealReward1;

    //实际激励（单位：分）
    @ApiModelProperty(value = "实际激励-霍2（单位：分）", required = false)
    private Long hegsRealReward2;

    //实际激励（单位：分）
    @ApiModelProperty(value = "实际激励-霍3（单位：分）", required = false)
    private Long hegsRealReward3;

    //实际激励（单位：分）
    @ApiModelProperty(value = "实际激励1（单位：分）", required = false)
    private Long realReward1;

    //实际激励（单位：分）
    @ApiModelProperty(value = "实际激励2（单位：分）", required = false)
    private Long realReward2;

    //实际激励（单位：分）
    @ApiModelProperty(value = "实际激励3（单位：分）", required = false)
    private Long realReward3;

    //实际激励（单位：分）
    @ApiModelProperty(value = "实际激励-杭（单位：分）", required = false)
    private Long hzRealReward;

    //实际激励（单位：分）
    @ApiModelProperty(value = "实际激励-霍（单位：分）", required = false)
    private Long hegsRealReward;

    //总分成比例
    @ApiModelProperty(value = "总分成比例", required = false)
    private Double sharingRate;

    //修改激励金额（单位：分）
    @ApiModelProperty(value = "调整理由", required = false)
    private String modifyReward;

    //结算状态（'待结算0|待媒体运营负责人审核1|待流量负责人审核2|已结算3|待风控审核4',）
    @ApiModelProperty(value = "结算状态（'待结算0|待媒体运营负责人审核1|待流量负责人审核2|已结算3|待风控审核4',）", required = false)
    private Integer settleStatus;

    //拒绝原因
    @ApiModelProperty(value = "拒绝原因", required = false)
    private String refuseReason;

    //结算时间
    @ApiModelProperty(value = "结算时间", required = false)
    private Date cashTime;

    @ApiModelProperty(value = "提现单号-杭", required = false)
    private Long hzCashOrderId;

    @ApiModelProperty(value = "提现单号-霍", required = false)
    private Long hegsCashOrderId;

    //媒体运营
    @ApiModelProperty(value = "媒体运营", required = false)
    private String mediaOperation;

    //风控审核人
    @ApiModelProperty(value = "风控审核人", required = false)
    private String riskOperation;

    //媒体运营负责人
    @ApiModelProperty(value = "媒体运营负责人", required = false)
    private String mediaOwner;

    //流量负责人
    @ApiModelProperty(value = "流量负责人", required = false)
    private String flowOwner;

    //审核时间
    @ApiModelProperty(value = "风控审核时间", required = false)
    private Date riskAuditTime;

    //审核时间
    @ApiModelProperty(value = "媒体运营负责人审核时间", required = false)
    private Date mediaAuditTime;

    //审核时间
    @ApiModelProperty(value = "流量负责人审核时间", required = false)
    private Date auditTime;

    //完成率=实际收入/季度任务
    @ApiModelProperty(value = "完成率")
    private Double incomeAchieveRate;

    //返点
    @ApiModelProperty(value = "返点")
    private String feedback;

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    private Integer auditStatus;

    private Integer queryStatus;

    private Date gmtCreate;

    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMrsId() {
        return mrsId;
    }

    public void setMrsId(Long mrsId) {
        this.mrsId = mrsId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email == null ? null : email.trim();
    }

    public Double getPredictScore() {
        return predictScore;
    }

    public void setPredictScore(Double predictScore) {
        this.predictScore = predictScore;
    }

    public Long getPredictReward() {
        return predictReward;
    }

    public void setPredictReward(Long predictReward) {
        this.predictReward = predictReward;
    }

    public Long getRealReward() {
        return realReward;
    }

    public void setRealReward(Long realReward) {
        this.realReward = realReward;
    }

    public Long getRealIncome() {
        return realIncome;
    }

    public void setRealIncome(Long realIncome) {
        this.realIncome = realIncome;
    }

    public Long getHegsRealReward1() {
        return hegsRealReward1;
    }

    public void setHegsRealReward1(Long hegsRealReward1) {
        this.hegsRealReward1 = hegsRealReward1;
    }

    public Long getHegsRealReward2() {
        return hegsRealReward2;
    }

    public void setHegsRealReward2(Long hegsRealReward2) {
        this.hegsRealReward2 = hegsRealReward2;
    }

    public Long getHegsRealReward3() {
        return hegsRealReward3;
    }

    public void setHegsRealReward3(Long hegsRealReward3) {
        this.hegsRealReward3 = hegsRealReward3;
    }

    public Long getRealReward1() {
        return realReward1;
    }

    public void setRealReward1(Long realReward1) {
        this.realReward1 = realReward1;
    }

    public Long getRealReward2() {
        return realReward2;
    }

    public void setRealReward2(Long realReward2) {
        this.realReward2 = realReward2;
    }

    public Long getRealReward3() {
        return realReward3;
    }

    public void setRealReward3(Long realReward3) {
        this.realReward3 = realReward3;
    }

    public Long getHzRealReward() {
        return hzRealReward;
    }

    public void setHzRealReward(Long hzRealReward) {
        this.hzRealReward = hzRealReward;
    }

    public Long getHegsRealReward() {
        return hegsRealReward;
    }

    public void setHegsRealReward(Long hegsRealReward) {
        this.hegsRealReward = hegsRealReward;
    }

    public Double getSharingRate() {
        return sharingRate;
    }

    public void setSharingRate(Double sharingRate) {
        this.sharingRate = sharingRate;
    }

    public String getModifyReward() {
        return modifyReward;
    }

    public void setModifyReward(String modifyReward) {
        this.modifyReward = modifyReward;
    }

    public Integer getSettleStatus() {
        return settleStatus;
    }

    public void setSettleStatus(Integer settleStatus) {
        this.settleStatus = settleStatus;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason == null ? null : refuseReason.trim();
    }

    public Date getCashTime() {
        return cashTime;
    }

    public void setCashTime(Date cashTime) {
        this.cashTime = cashTime;
    }

    public Long getHzCashOrderId() {
        return hzCashOrderId;
    }

    public void setHzCashOrderId(Long hzCashOrderId) {
        this.hzCashOrderId = hzCashOrderId;
    }

    public Long getHegsCashOrderId() {
        return hegsCashOrderId;
    }

    public void setHegsCashOrderId(Long hegsCashOrderId) {
        this.hegsCashOrderId = hegsCashOrderId;
    }

    public String getMediaOperation() {
        return mediaOperation;
    }

    public void setMediaOperation(String mediaOperation) {
        this.mediaOperation = mediaOperation == null ? null : mediaOperation.trim();
    }

    public String getMediaOwner() {
        return mediaOwner;
    }

    public void setMediaOwner(String mediaOwner) {
        this.mediaOwner = mediaOwner == null ? null : mediaOwner.trim();
    }

    public String getFlowOwner() {
        return flowOwner;
    }

    public void setFlowOwner(String flowOwner) {
        this.flowOwner = flowOwner == null ? null : flowOwner.trim();
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Integer getQueryStatus() {
        return queryStatus;
    }

    public void setQueryStatus(Integer queryStatus) {
        this.queryStatus = queryStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Double getRealScore() {
        return realScore;
    }

    public void setRealScore(Double realScore) {
        this.realScore = realScore;
    }

    public String getRiskOperation() {
        return riskOperation;
    }

    public void setRiskOperation(String riskOperation) {
        this.riskOperation = riskOperation;
    }

    public Date getRiskAuditTime() {
        return riskAuditTime;
    }

    public void setRiskAuditTime(Date riskAuditTime) {
        this.riskAuditTime = riskAuditTime;
    }

    public Date getMediaAuditTime() {
        return mediaAuditTime;
    }

    public void setMediaAuditTime(Date mediaAuditTime) {
        this.mediaAuditTime = mediaAuditTime;
    }

    public Double getIncomeAchieveRate() {
        return incomeAchieveRate;
    }

    public void setIncomeAchieveRate(Double incomeAchieveRate) {
        this.incomeAchieveRate = incomeAchieveRate;
    }

    public String getFeedback() {
        return feedback;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }
}
