package cn.com.duiba.tuia.ssp.center.api.econtract.util;


import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

public class RestRequestUtil {

    private final static RestTemplate restTemplate = new RestTemplate();

    public static <T> T sendHttpGet(String host, String method, String urlParams,Class<T> responseType) {

        String requestUrl = host + method + urlParams;

        return sendGet( requestUrl,  responseType);
    }

    public static <T> T sendHttpPost(String host, String method, String urlParams, String sendData,Class<T> responseType) {

        String requestUrl = host + method + urlParams;

        return sendPost( requestUrl, null,sendData, responseType);
    }


    public static <T> T sendPost( String url, Map<String, String> headers, Object sendData,Class<T> responseType) {

        HttpHeaders httpHeaders = new HttpHeaders();
        if(!CollectionUtils.isEmpty(headers)){
            headers.forEach((key,value) -> httpHeaders.add(key,value));
        }

        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        httpHeaders.add("Accept", MediaType.APPLICATION_JSON.toString());

        HttpEntity<String> httpEntity = new HttpEntity(sendData,httpHeaders);
        return restTemplate.postForObject(url,httpEntity, responseType);
    }

    public static <T> T sendGet( String url, Map<String, ?> urlVariables,Class<T> responseType) {
        return restTemplate.getForObject(url,responseType,urlVariables);
    }

    public static <T> T sendGet( String url,Class<T> responseType) {
        return restTemplate.getForObject(url,responseType);
    }

}
