package cn.com.duiba.tuia.ssp.center.api.remote.accountAmountVerify;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.accountAmountVerify.*;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface  RemoteAccountAmountVerifyService {

    /**
     * 业务端分页查询媒体账户金额验证列表
     *
     * @param param param
     * @return 媒体金额验证列表
     */
    PageResultDto<WebAccountAmountMonthRecordDto> pageWebByParam(ReqPageWebAmountVerify param);


    /**
     * 管理端业务端分页查询媒体账户金额验证列表
     *
     * @param param param
     * @return 媒体金额验证列表
     */
    PageResultDto<ManagerAccountAmountVerifyLogDto> pageManagerByParam(ReqPageManagerAmountVerify param);

    /**
     * 修改媒体账户金额状态
     *
     * @param param
     * @return Integer
     */
    Boolean webSaveOrUpdateVerifyStatus(AccountAmountVerifyLogDto param);

    /**
     * 修改媒体账户金额状态
     *
     * @param param
     * @return Integer
     */
    Boolean managerUpdateVerifyStatus(AccountAmountVerifyLogDto param);


    List<ManagerAccountAmountVerifyLogDto> selectList(ReqPageManagerAmountVerify param);

    Map<String,Integer> allAccountAmountIsVerifyByMediaId(Long mediaId);

}
