package cn.com.duiba.tuia.ssp.center.api.dto.accountAmountVerify;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;

import javax.validation.constraints.NotNull;
import java.util.List;


public class ReqPageManagerAmountVerify extends BaseQueryDto {

    /**
     * 审核状态
     */
    @ApiModelProperty(value = "审核状态", required = false)
    private Integer verifyStatus;

    @ApiModelProperty(value = "收入来源：0-杭州 1-霍尔果斯", required = false)
    private Integer incomeSource;

    @ApiModelProperty(value = "开始月份", required = true)
    @NotNull(message = "开始月份不能为空")
    private String startMonth;

    @ApiModelProperty(value = "结束月份", required = true)
    @NotNull(message = "结束月份不能为空")
    private String endMonth;

    @ApiModelProperty(value = "账号 ID", required = false)
    private Long mediaId;

    @ApiModelProperty(value = "邮箱账号", required = false)
    private String email;

    @ApiModelProperty(value = "账号类别", required = false)
    private Integer accountType;

    public String getStartMonth() {
        return startMonth;
    }

    public void setStartMonth(String startMonth) {
        this.startMonth = startMonth;
    }

    public String getEndMonth() {
        return endMonth;
    }

    public void setEndMonth(String endMonth) {
        this.endMonth = endMonth;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Integer getVerifyStatus() {
        return verifyStatus;
    }

    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    public Integer getIncomeSource() {
        return incomeSource;
    }

    public void setIncomeSource(Integer incomeSource) {
        this.incomeSource = incomeSource;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
