package cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.advert;

import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/**
 * 〈一句话功能简述〉<br>
 * Description: 广告互选：广告端广告基本信息
 *
 * @author hillchen
 * @create 2018/10/23 10:38
 */
public class AdvertBaseReq implements Serializable {

    private static final long serialVersionUID = 6875504206151321932L;
    /**
     * 新广告二级行业标签
     */
    private String tagCode;
    /**
     * 新广告二级属性标签（新增）
     */
    private Set<String> attrTagCode;

    /**
     * 新广告二级落地页标签(新增)
     */
    private Set<String> loadPageCode;
    /**
     * 新广告Id(字段名变更)
     */
    private Long advertId;

    private Integer advertType;

    public String getTagCode() {
        return tagCode;
    }

    public void setTagCode(String tagCode) {
        this.tagCode = tagCode;
    }

    public Set<String> getAttrTagCode() {
        return attrTagCode;
    }

    public void setAttrTagCode(Set<String> attrTagCode) {
        this.attrTagCode = attrTagCode;
    }

    public Set<String> getLoadPageCode() {
        return loadPageCode;
    }

    public void setLoadPageCode(Set<String> loadPageCode) {
        this.loadPageCode = loadPageCode;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    public Set<String> computeAdvertTagSet(){
        Set<String> advertTags = new HashSet<>();

        advertTags.add(tagCode);
        if(CollectionUtils.isNotEmpty(attrTagCode)){
            advertTags.addAll(advertTags);
        }
        if(CollectionUtils.isNotEmpty(loadPageCode)){
            advertTags.addAll(loadPageCode);
        }

        return advertTags;
    }
}