package cn.com.duiba.tuia.ssp.center.api.dto.prePayInvoiceRecord;

import cn.com.duiba.tuia.ssp.center.api.dto.common.BasePage;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;

public class PrePayInvoiceRecordReq extends BasePage {

    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期为空")
    private String startDate;

    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期为空")
    private String endDate;

    @ApiModelProperty(value = "媒体用户ID", required = false)
    private Long mediaId;

    @ApiModelProperty(value = "开票方式：0-消耗 1-打款", required = false)
    private Integer invoiceWay;

    @ApiModelProperty(value = "开票主体：0-杭州 1-霍尔果斯", required = false)
    private Integer invoiceBody;

    @ApiModelProperty(value = "发票状态：0-媒介助理 1-已提交财务", required = false)
    private Integer invoiceStatus;




    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Integer getInvoiceWay() {
        return invoiceWay;
    }

    public void setInvoiceWay(Integer invoiceWay) {
        this.invoiceWay = invoiceWay;
    }

    public Integer getInvoiceBody() {
        return invoiceBody;
    }

    public void setInvoiceBody(Integer invoiceBody) {
        this.invoiceBody = invoiceBody;
    }

    public Integer getInvoiceStatus() {
        return invoiceStatus;
    }

    public void setInvoiceStatus(Integer invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
