/**
 * Project Name:ssp-center-api
 * File Name:RemoteMediaQualificationRecordService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2018年2月7日下午7:35:41
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaQualificationRecordDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqFinanceByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqUpdateFinanceDto;

/**
 * ClassName:RemoteMediaQualificationRecordService <br/>
 * Function: 媒体资质认证记录. <br/>
 * Date:     2018年2月7日 下午7:35:41 <br/>
 * @author   guyan
 * @version  
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteMediaQualificationRecordService {
    
    /**
     * 
     * selectList:(查询媒体资质认证list). <br/>
     *
     * @author guyan
     * @param param
     * @return
     */
    List<MediaQualificationRecordDto> selectList(ReqFinanceByPage param);
    
    /**
     * 
     * selectCount:(查询媒体资质认证数量). <br/>
     *
     * @author guyan
     * @param param
     * @return
     */
    Integer selectCount(ReqFinanceByPage param);
    
    /**
     * insertRecord:(插入数据). <br/>
     *
     * @author guyan
     * @param dto
     */
    void insertRecord(MediaQualificationRecordDto dto);
    
    /**
     * updateLastRecord:(更新最后一条记录). <br/>
     *
     * @author guyan
     * @param dto
     */
    void updateLastRecord(ReqUpdateFinanceDto dto);

    /**
     * 查询资质认证记录中使用过指定开户人的媒体账号id
     * @param accountOpenman
     * @return
     */
    List<Long> selectMediaIds(String accountOpenman);

}

