package cn.com.duiba.tuia.ssp.center.api.remote.advertselect.remoteservice.media;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.advertselect.*;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br>
 * Description: 新广告位屏蔽策略信息远程服务入口
 *
 * @author hillchen
 * @create 2018/10/24 16:16
 */
@AdvancedFeignClient
public interface RemoteSlotStrategyService {

    /**
     * 分页查询广告位屏蔽策略
     * @param slotShieldPageQuery
     * @return
     */
    PageResultDto<SlotShieldStrategyDto> findSlotShieldStrategyList(SlotShieldPageQuery slotShieldPageQuery);


    /**
     * 根据广告位屏蔽策略查询所有所有可见标签统计信息
     * @param slotStrategyId
     * @return
     */
    List<TagInfoDto> findAllTags(Long slotStrategyId);

    /**
     * 查询广告位屏蔽策略下对应各个维度的广告数
     * @param strategyIds
     * @return
     */
    Map<Long, StrategyAdvertCountDto> countStrategyAdverts(Collection<Long> strategyIds);

    /**
     * 查询单个广告位屏蔽策略下对应各个维度的广告数
     * @param strategyId
     * @return
     */
    StrategyAdvertCountDto countStrategyAdvert(Long strategyId);

    List<TagLevelInfo> findVisibleBuzTagTree(Long mediaId);

    /**
     * 广告互选数据初始化
     * @param mediaId
     */
    void initAdvertSelectV2Data(Long mediaId);




}