/**
 * Project Name:media-api<br>
 * File Name:ReqGetAccountByPageDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年10月8日上午11:48:15<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName: ReqGetAccountByPageDto <br/>
 * date: 2016年10月8日 上午11:48:15 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqGetAccountByPageDto extends BaseQueryDto {

    /** 媒体账户审核中请求参数 */
    public static final int   REQ_ACCOUNT_CHECK_ING     = 0;
    /** 媒体账户冻结请求参数 */
    public static final int   REQ_ACCOUNT_CHECK_FREEZED = 1;
    /** 媒体账户通过请求参数 */
    public static final int   REQ_ACCOUNT_CHECK_PASS    = 2;
    /** 媒体账户拒绝请求参数 */
    public static final int   REQ_ACCOUNT_CHECK_REFUSE  = 3;
    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID          = -3459748145567619125L;
    /** 邮箱. */
    @ApiModelProperty(value = "邮箱", required = false)
    private String            email;

    /** 邮箱状态:0：未验证;1：已验证. */
    @ApiModelProperty(value = "邮箱状态", required = false)
    private Integer           emailStatus;

    /** 审核状态:0：审核中;1：审核通过;2：审核拒绝. */
    @ApiModelProperty(value = "审核状态", required = false)
    private Integer           checkStatus;

    /** 冻结状态:0-未冻结;1-已冻结. */
    @ApiModelProperty(value = "冻结状态", required = false)
    private Integer           freezeStatus;

    /** 开发者ID */
    @ApiModelProperty(value = "开发者ID", required = false)
    private Long              mediaId;

    @ApiModelProperty(value = "线下打款状态位，0-非线下打款公司,1-线下打款公司")
    private Integer           isOffline;

    /** 用户类别 */
    @ApiModelProperty(value = "账号类别: 0-未选 1-直客 2-代理 3-子账户")
    private Integer           accountType;

    /** 媒体ID */
    @ApiModelProperty(value = "媒体ID")
    private Long              appId;

    @ApiModelProperty(value = "公司名称")
    private String            companyName;

    @ApiModelProperty(value = "广告位")
    private Long              slotId;

    @ApiModelProperty(value = "客户类型")
    private Integer             clientType;

    /**
     * getReqConvertParam:(获取请求转换参数). <br/>
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    public static void getReqConvertParam(ReqGetAccountByPageDto param) {
        if (param != null && param.getCheckStatus() != null) {
            Integer status = param.getCheckStatus();
            switch (status) {
                case REQ_ACCOUNT_CHECK_ING: // 审核中
                    param.setCheckStatus(AccountDto.CHECK_STATUS_ING);
                    break;
                case REQ_ACCOUNT_CHECK_FREEZED: // 已冻结
                    param.setFreezeStatus(AccountDto.FREEZED_STATUS);
                    break;
                case REQ_ACCOUNT_CHECK_PASS: // 审核通过
                    param.setCheckStatus(AccountDto.CHECK_STATUS_PASS);
                    break;
                case REQ_ACCOUNT_CHECK_REFUSE: // 审核拒绝
                    param.setCheckStatus(AccountDto.CHECK_STATUS_REFUSE);
                    break;
                default:
                    break;
            }
        }
    }

    /**
     * freezeStatus.
     *
     * @return the freezeStatus
     * @since JDK 1.6
     */
    public Integer getFreezeStatus() {
        return freezeStatus;
    }

    /**
     * freezeStatus.
     *
     * @param freezeStatus the freezeStatus to set
     * @since JDK 1.6
     */
    public void setFreezeStatus(Integer freezeStatus) {
        this.freezeStatus = freezeStatus;
    }

    /**
     * email.
     *
     * @return the email
     * @since JDK 1.6
     */
    public String getEmail() {
        return email;
    }

    /**
     * email.
     *
     * @param email the email to set
     * @since JDK 1.6
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * emailStatus.
     *
     * @return the emailStatus
     * @since JDK 1.6
     */
    public Integer getEmailStatus() {
        return emailStatus;
    }

    /**
     * emailStatus.
     *
     * @param emailStatus the emailStatus to set
     * @since JDK 1.6
     */
    public void setEmailStatus(Integer emailStatus) {
        this.emailStatus = emailStatus;
    }

    /**
     * checkStatus.
     *
     * @return the checkStatus
     * @since JDK 1.6
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.6
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Integer getIsOffline() {
        return isOffline;
    }

    public void setIsOffline(Integer isOffline) {
        this.isOffline = isOffline;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Integer getClientType() {
        return clientType;
    }

    public void setClientType(Integer clientType) {
        this.clientType = clientType;
    }
}
