package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.tuia.ssp.center.api.dto.mediaapp.StatisticsCvrDto;
import cn.com.duiba.tuia.ssp.center.api.dto.mediaapp.StatisticsCvrRsp;
import cn.com.duiba.tuia.ssp.center.api.dto.mediaapp.StatisticsDateCvrDto;
import cn.com.duiba.tuia.ssp.center.api.dto.mediaapp.StatisticsDateCvrRsp;
import cn.com.duiba.tuia.ssp.center.api.tool.idsquery.IdsQueryParam;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMediaActivitySlotStatisticsStatService {
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<Integer> selectSlotDataCount(ReqSlotStatDataByPage req);

    DubboResult<Integer> selectSlotDailyDataCount(ReqSlotStatDailyByPage req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectSlotData(ReqSlotStatDataByPage req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<MeidaActivitySlotStatisticsDto> selectSumSlotData(ReqSlotStatDataByPage req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectSlotDailyData(ReqSlotStatDailyByPage req);

    DubboResult<Integer> updateSlotDailyData(ReqUpdateSlotDailyData req);

    DubboResult<Integer> batchUpdateSlotDailyData(List<ManualSlotDailyStatDto> req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectSlotDailyDataBySlotAndDate(List<ManualSlotDailyStatDto> req);

    /**
     * 获取去媒体数据
     * @param req
     * @return
     */
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectAppData(ReqAppStatistics req);

    /**
     * 获取媒体数据的总计
     * @param req
     * @return
     */
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<MeidaActivitySlotStatisticsDto> selectAppSumData(ReqAppStatistics req);

    /**
     * 获取媒体数据数量，做分页用
     * @param req
     * @return
     */
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<Integer> selectAppDataCount(ReqAppStatistics req);

    /**
     * 获取媒体数据每日数据量
     * @param req
     * @return
     */
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<Integer> selectAppDailyDataCount(ReqAppDailyStatistics req);

    /**
     * 获取媒体数据每日数据
     * @param req
     * @return
     */
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectAppDailyData(ReqAppDailyStatistics req);

    DubboResult<Integer> selectAppSlotDailyCount(ReqAppSlotDailyStatistics req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectAppSlotDailyData(ReqAppSlotDailyStatistics req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectAppSlotData(ReqAppSlotStatistics req);

    DubboResult<MeidaActivitySlotStatisticsDto> selectAppSlotSumData(ReqAppSlotStatistics req);

    DubboResult<Integer> selectAppSlotDataCount(ReqAppSlotStatistics req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectChangeSlotTotalData(ReqAppStatistics req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<MeidaActivitySlotStatisticsDto> selectChangeSlotTotalSumData(ReqAppStatistics req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectChangeSlotDailyData(ReqAppDailyStatistics req);

    DubboResult<Integer> selectActivityMediaSoltAmount(ReqActivitySlotDataByPage param);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<Integer> selectActivitySoltAmount(ReqActivitySlotDataByPage param);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    List<ActivitySlotCountDto> selectBatchActivitySoltAmount(ReqActivitySlotDataByPage reqActivitySlotDataByPage);

    DubboResult<Integer> selectActivitySoltDailyAmount(ReqActivitySlotDataByPage param);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<Integer> selectActivityStatCount(ReqActivityStatDataByPage req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectActivityStatData(ReqActivityStatDataByPage req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    List<MeidaActivitySlotStatisticsDto> selectActivityStatDataByActIds(ReqActivityStatDataByPage reqActivityStatDataByPage);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<MeidaActivitySlotStatisticsDto> selectActivityStatSumData(ReqActivityStatDataByPage req);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<Integer> selectActAppStatCount(ReqActAppStatDataByPage req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectActAppStatData(ReqActAppStatDataByPage req);

    DubboResult<MeidaActivitySlotStatisticsDto> selectActAppStatSumData(ReqActAppStatDataByPage req);

    DubboResult<Integer> selectActAppStatDailyCount(ReqActAppStatDailyByPage req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectActAppStatDailyData(ReqActAppStatDailyByPage req);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectActivityMediaSoltDataByPage(ReqActivitySlotDataByPage param);

    DubboResult<MeidaActivitySlotStatisticsDto> selectActivityMediaSoltSumData(ReqActivitySlotDataByPage param);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectActivitySoltDataByPage(ReqActivitySlotDataByPage param);

    DubboResult<MeidaActivitySlotStatisticsDto> selectActivitySoltSumData(ReqActivitySlotDataByPage param);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectActivitySoltDailyByPage(ReqActivitySlotDataByPage param);

    DubboResult<MeidaActivitySlotStatisticsDto> selectSlotDailyDataById(Long id);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectSlotActByPage(ReqActivitySlotDataByPage req);

    DubboResult<MeidaActivitySlotStatisticsDto> selectSlotActTotal(ReqActivitySlotDataByPage req);

    DubboResult<Integer> selectSlotActAmount(ReqActivitySlotDataByPage req);

    /**
     *
     * selectActivityDailyAmount:(查询活动每日数据数量). <br/>
     *
     * @author guyan
     * @param req
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer>  selectActivityDailyAmount(ReqActDailyStatDataByPage req);

    /**
     *
     * selectActivityDailyData:(查询活动每日数据). <br/>
     *
     * @author guyan
     * @param req
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<MeidaActivitySlotStatisticsDto>>  selectActivityDailyData(ReqActDailyStatDataByPage req);

    /**
     * 查询app的cvr值
     * @param statisticsCvrRsp
     * @return
     */
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    List<StatisticsCvrDto> selectAppStatisticsCvrDto(StatisticsCvrRsp statisticsCvrRsp);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    List<StatisticsDateCvrDto> selectAppDateStatisticsCvrDto(StatisticsDateCvrRsp statisticsCvrRsp);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    List<StatisticsCvrDto> selectSlotStatisticsCvrDto(StatisticsCvrRsp statisticsCvrRsp);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    List<StatisticsDateCvrDto> selectSlotDateStatisticsCvrDto(StatisticsDateCvrRsp statisticsCvrRsp);

}
