package cn.com.duiba.tuia.ssp.center.api.remote.advertselect.context;

import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.context.AdvertSelectContextDto;
import com.alibaba.ttl.TransmittableThreadLocal;

import java.util.Objects;

/**
 *
 */
public class AdvertSelectContext {

    /**
     * 本地线程
     */
    private static final TransmittableThreadLocal<AdvertSelectContextDto> local = new TransmittableThreadLocal<>();

    private static class Holder {
        private static AdvertSelectContext context = new AdvertSelectContext();
    }

    /**
     * The Constructor.
     */
    private AdvertSelectContext() {

    }

    public static AdvertSelectContext getContext() {
        return Holder.context;
    }

    /**
     * @return
     */
    public AdvertSelectContextDto get() {
        AdvertSelectContextDto dto=local.get();
        System.out.println("dto.getRequestIp() = " + dto.getRequestIp());
        if (Objects.isNull(local.get())) {
            return new AdvertSelectContextDto();
        }
        return local.get();

    }

    /**
     * @param dto
     */
    public void set(AdvertSelectContextDto dto) {
        local.set(dto);
    }
}
