/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.dto.monthreport;

import cn.com.duiba.tuia.ssp.center.api.dto.monthreport.GetSetDate;
import java.io.Serializable;
import java.math.BigDecimal;

public class EntranceData
implements Serializable,
GetSetDate {
    private static final long serialVersionUID = -1061273223861419617L;
    private String date;
    private Long exposureCount = 0L;
    private Long clickCount = 0L;
    private Float clickRate = Float.valueOf(0.0f);

    public EntranceData() {
    }

    public EntranceData(String date, Long exposureCount, Long clickCount) {
        this.date = date;
        this.exposureCount = exposureCount;
        this.clickCount = clickCount;
        this.clickRate = EntranceData.calculateClickRate(this.clickCount, this.exposureCount);
    }

    public EntranceData merge(EntranceData other) {
        this.exposureCount = this.exposureCount + other.getExposureCount();
        this.clickCount = this.clickCount + other.getClickCount();
        this.clickRate = EntranceData.calculateClickRate(this.clickCount, this.exposureCount);
        return this;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public void setDate(String date) {
        this.date = date;
    }

    public Long getExposureCount() {
        return this.exposureCount;
    }

    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    public Long getClickCount() {
        return this.clickCount;
    }

    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    public Float getClickRate() {
        return this.clickRate;
    }

    public void setClickRate(Float clickRate) {
        this.clickRate = clickRate;
    }

    public static Float calculateClickRate(Long divisor, Long dividend) {
        Float result = null;
        if (dividend != null && divisor != null && divisor != 0L && dividend != 0L) {
            BigDecimal bigDivisor = new BigDecimal(divisor * 100L);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return Float.valueOf(bigDivisor.divide(bigDividend, 2, 4).floatValue());
        }
        return result;
    }
}

