package cn.com.duiba.tuia.ssp.center.api.econtract.dto.realname;

import cn.com.duiba.tuia.ssp.center.api.econtract.util.EcontractConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 〈一句话功能简述〉<br>
 * Description: 媒体实名认证审核结果对象
 *
 * @author hillchen
 * @create 2019/1/23 10:39
 */
@ApiModel(value = "媒体实名认证审核结果对象")
public class RealnameAuditResult implements Serializable {

    private static final long serialVersionUID = -1790827163640894561L;

    @ApiModelProperty(value = "媒体账号id")
    private Long mediaId;

    @ApiModelProperty(value = "审核处理状态：(1:通过,2:拒绝)")
    private Integer auditResult;

    @ApiModelProperty(value = "审核说明")
    private String auditMsg;

    @ApiModelProperty(value = "拒绝类型:(1:手持身份证照片与填写信息不一致,2:授权证明信息有误)")
    private Integer refuseType;

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Integer getAuditResult() {
        return auditResult;
    }

    public void setAuditResult(Integer auditResult) {
        this.auditResult = auditResult;
    }

    public String getAuditMsg() {
        return auditMsg;
    }

    public void setAuditMsg(String auditMsg) {
        this.auditMsg = auditMsg;
    }

    public Integer getRefuseType() {
        return refuseType;
    }

    public void setRefuseType(Integer refuseType) {
        this.refuseType = refuseType;
    }

    public boolean passAudit(){
        return EcontractConstant.AuditResult.auditSucc(auditResult);
    }
}