package cn.com.duiba.tuia.ssp.center.api.econtract.util;

import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.BestsignRequestResult;
import cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.BestsignRequestStringResult;
import cn.com.duiba.tuia.ssp.center.api.econtract.exception.BestsignResultErrorException;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.io.OutputStream;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 上上签混合云SDK客户端
 */
public class BestsignOpenApiClient {
	/** The logger. */
	protected static Logger logger = LoggerFactory.getLogger(BestsignOpenApiClient.class);

	private static String baseUrlParams = "developerId=%s&rtick=%s&signType=rsa";

	public static <T>T getRequest(BestsignPropertie bestsignPropertie, String path, Map<String,String> params,Class<T> responseType){
		// 生成一个时间戳参数
		String rtick = RSAUtils.getRtick();
		//生成url
		String urlParams = createUrlParams(bestsignPropertie,params,rtick);
		//生成签名
		String paramsSign = RSAUtils.calcRsaSignNoEncode(bestsignPropertie.getDeveloperId(),
				bestsignPropertie.getPrivateKey(), bestsignPropertie.getServerHost(), path, rtick, urlParams,
				null);
		//组装签名到url
		String requestUrl = urlParams  + "&sign=" + paramsSign;

		//调用请求并返回响应结果
		return RestRequestUtil.sendHttpGet(bestsignPropertie.getServerHost(),path,requestUrl,responseType);
	}


	public static <T> BestsignRequestResult<T>  postBestRequest(BestsignPropertie bestsignPropertie, String path, String sendData,Class<T> responseType)
			throws BestsignResultErrorException{

		BestsignRequestResult<T> result = buildResult(postRequest(bestsignPropertie,path,sendData),responseType);
		checkResult(result);
		return result;
	}

	public static String postRequest(BestsignPropertie bestsignPropertie, String path, String sendData){
		 String result = postRequest(bestsignPropertie,path,sendData,String.class);
		logger.info(String.format("发送上上签请求[%s],请求参数%s,响应结果%s",path,sendData,result));
		return result;
	}


	public static <T>T postRequest(BestsignPropertie bestsignPropertie, String path, String sendData,Class<T> responseType){
		// 生成一个时间戳参数
		String rtick = RSAUtils.getRtick();
		//生成url
		String urlParams = createUrlParams(bestsignPropertie,null,rtick);
		//生成签名
		String paramsSign = RSAUtils.calcRsaSignNoEncode(bestsignPropertie.getDeveloperId(),
				bestsignPropertie.getPrivateKey(), bestsignPropertie.getServerHost(), path, rtick, null,
				sendData);
		//组装签名到url
		String requestUrl = urlParams  + "&sign=" + paramsSign;

		//调用请求并返回响应结果
		return RestRequestUtil.sendHttpPost(bestsignPropertie.getServerHost(),path,requestUrl,sendData,responseType);
	}


	private static <T> BestsignRequestResult<T> buildResult(String resultBody, Class<T> dataType){
		if(StringUtils.isNotBlank(resultBody)){
			BestsignRequestStringResult bestsignRequestStringResult = JSONObject.parseObject(resultBody,BestsignRequestStringResult.class);
			if(bestsignRequestStringResult != null){
				return bestsignRequestStringResult.convert(dataType);
			}
		}
		return null;
	}

	private static String createUrlParams(BestsignPropertie bestsignPropertie,Map<String,String> params,String rtick){
		String baseUrl = String.format(baseUrlParams,bestsignPropertie.getDeveloperId(),rtick);

		StringBuilder urlParamsBuilder = new StringBuilder("?");
		urlParamsBuilder.append(baseUrl);
		if(!CollectionUtils.isEmpty(params)){
			params.forEach((key,value) -> urlParamsBuilder.append("&").append(key).append("=").append(value));
		}
		return urlParamsBuilder.toString();
	}

	private static String createSignParams(Map<String,String> params){
		if(!CollectionUtils.isEmpty(params)){

			return params.entrySet().stream().map(entry -> entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining("&"));
		}
		return "";
	}


	public static void checkResult(BestsignRequestResult bestsignRequestResult) throws BestsignResultErrorException {
		if(bestsignRequestResult == null){
			throw new BestsignResultErrorException("上上签结果响应异常");
		}
	}

	public static void downloadByGet(BestsignPropertie bestsignPropertie, String path, Map<String,String> params, OutputStream outputStream){
		// 生成一个时间戳参数
		String rtick = RSAUtils.getRtick();
		String signParams = createSignParams(params);
		//生成签名
		String paramsSign = RSAUtils.calcRsaSignNoEncode(bestsignPropertie.getDeveloperId(),
				bestsignPropertie.getPrivateKey(), bestsignPropertie.getServerHost(), path, rtick, signParams,
				null);

		//生成url
		String urlParams = createUrlParams(bestsignPropertie,params,rtick);
		//组装签名到url
		String requestUrl = urlParams  + "&sign=" + paramsSign;
		RestRequestUtil.downloadByGet(bestsignPropertie.getServerHost(),path,requestUrl,outputStream);
	}

}
