package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * 激励规则对象
 */
@ApiModel
public class RewardStrategyDto implements Serializable {

    private static final long serialVersionUID = -4248762917522733769L;

    //规则主键id
    @ApiModelProperty(value = "ID")
    private Long id;

    //评分规则
    @ApiModelProperty(value = "评分规则", required = true)
    private GradeRule gradeRule;

    //当前月份（‘2017-11’）
    @ApiModelProperty(value = "当前月份（‘2017-11’）", required = true)
    private String curMonth;

    private Date gmtCreate;

    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCurMonth() {
        return curMonth;
    }

    public void setCurMonth(String curMonth) {
        this.curMonth = curMonth == null ? null : curMonth.trim();
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * 评级规则
     */
    @ApiModel
    public static class GradeRule implements Serializable {

        private static final long serialVersionUID = 2944621017272694759L;
        //质量分占比
        @ApiModelProperty(value = "质量分占比", required = true)
        private Double qualityRatio;
        //量级分占比
        @ApiModelProperty(value = "量级分占比", required = true)
        private Double levelRatio;
        //流量类型分占比
        @ApiModelProperty(value = "流量类型分占比", required = true)
        private Double flowRatio;

        @ApiModelProperty(value = "稳定性得分占比", required = true)
        private Double stableRatio;

        @ApiModelProperty(value = "真实性得分占比", required = true)
        private Double truthRatio;

        @ApiModelProperty(value = "广告匹配得分占比", required = true)
        private Double matchingRatio;

        public Double getMatchingRatio() {
            return matchingRatio;
        }

        public void setMatchingRatio(Double matchingRatio) {
            this.matchingRatio = matchingRatio;
        }

        public Double getQualityRatio() {
            return qualityRatio;
        }

        public void setQualityRatio(Double qualityRatio) {
            this.qualityRatio = qualityRatio;
        }

        public Double getLevelRatio() {
            return levelRatio;
        }

        public void setLevelRatio(Double levelRatio) {
            this.levelRatio = levelRatio;
        }

        public Double getFlowRatio() {
            return flowRatio;
        }

        public void setFlowRatio(Double flowRatio) {
            this.flowRatio = flowRatio;
        }

        public Double getStableRatio() {
            return stableRatio;
        }

        public void setStableRatio(Double stableRatio) {
            this.stableRatio = stableRatio;
        }

        public Double getTruthRatio() {
            return truthRatio;
        }

        public void setTruthRatio(Double truthRatio) {
            this.truthRatio = truthRatio;
        }
    }

    public GradeRule getGradeRule() {
        return gradeRule;
    }

    public void setGradeRule(GradeRule gradeRule) {
        this.gradeRule = gradeRule;
    }
}
