package cn.com.duiba.tuia.ssp.center.api.constant;

/**
 * 合同状态
 * @version v1.0
 * @auther yuantong
 * @date 2019/05/28 09:37
 */
public enum ContractStstusEnum {

    WAIT((byte)1, "待签署"),
    SIGNED((byte)2, "已签署"),
    EXPIRE((byte)3, "已过期，待签署");

    private Byte type;

    private String desc;

    ContractStstusEnum(Byte type, String desc) {
        this.type = type;
        this.desc = desc;
    }
    public Byte getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByType(Byte type) {
        for (ContractStstusEnum e : ContractStstusEnum.values()) {
            if (e.getType().equals(type)) {
                return e.getDesc();
            }
        }
        return "";
    }
}

